/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.Requirement;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PluginDescriptorGenerator
implements Generator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        String encoding = "UTF-8";
        File f = new File(destinationDirectory, "plugin.xml");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding);
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer, encoding, null);
            w.startElement("plugin");
            this.element((XMLWriter)w, "description", pluginDescriptor.getDescription());
            this.element((XMLWriter)w, "groupId", pluginDescriptor.getGroupId());
            this.element((XMLWriter)w, "artifactId", pluginDescriptor.getArtifactId());
            this.element((XMLWriter)w, "version", pluginDescriptor.getVersion());
            this.element((XMLWriter)w, "goalPrefix", pluginDescriptor.getGoalPrefix());
            this.element((XMLWriter)w, "isolatedRealm", "" + pluginDescriptor.isIsolatedRealm());
            this.element((XMLWriter)w, "inheritedByDefault", "" + pluginDescriptor.isInheritedByDefault());
            w.startElement("mojos");
            if (pluginDescriptor.getMojos() != null) {
                Iterator it = pluginDescriptor.getMojos().iterator();
                while (it.hasNext()) {
                    MojoDescriptor descriptor = (MojoDescriptor)it.next();
                    this.processMojoDescriptor(descriptor, (XMLWriter)w);
                }
            }
            w.endElement();
            PluginUtils.writeDependencies((XMLWriter)w, pluginDescriptor);
            w.endElement();
            ((Writer)writer).flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    protected void processMojoDescriptor(MojoDescriptor mojoDescriptor, XMLWriter w) {
        Parameter parameter;
        w.startElement("mojo");
        w.startElement("goal");
        w.writeText(mojoDescriptor.getGoal());
        w.endElement();
        String description = mojoDescriptor.getDescription();
        if (description != null) {
            w.startElement("description");
            w.writeText(mojoDescriptor.getDescription());
            w.endElement();
        }
        if (mojoDescriptor.isDependencyResolutionRequired() != null) {
            this.element(w, "requiresDependencyResolution", mojoDescriptor.isDependencyResolutionRequired());
        }
        this.element(w, "requiresDirectInvocation", "" + mojoDescriptor.isDirectInvocationOnly());
        this.element(w, "requiresProject", "" + mojoDescriptor.isProjectRequired());
        this.element(w, "requiresReports", "" + mojoDescriptor.isRequiresReports());
        this.element(w, "aggregator", "" + mojoDescriptor.isAggregator());
        this.element(w, "requiresOnline", "" + mojoDescriptor.isOnlineRequired());
        this.element(w, "inheritedByDefault", "" + mojoDescriptor.isInheritedByDefault());
        if (mojoDescriptor.getPhase() != null) {
            this.element(w, "phase", mojoDescriptor.getPhase());
        }
        if (mojoDescriptor.getExecutePhase() != null) {
            this.element(w, "executePhase", mojoDescriptor.getExecutePhase());
        }
        if (mojoDescriptor.getExecuteGoal() != null) {
            this.element(w, "executeGoal", mojoDescriptor.getExecuteGoal());
        }
        if (mojoDescriptor.getExecuteLifecycle() != null) {
            this.element(w, "executeLifecycle", mojoDescriptor.getExecuteLifecycle());
        }
        w.startElement("implementation");
        w.writeText(mojoDescriptor.getImplementation());
        w.endElement();
        w.startElement("language");
        w.writeText(mojoDescriptor.getLanguage());
        w.endElement();
        if (mojoDescriptor.getComponentConfigurator() != null) {
            w.startElement("configurator");
            w.writeText(mojoDescriptor.getComponentConfigurator());
            w.endElement();
        }
        if (mojoDescriptor.getComponentComposer() != null) {
            w.startElement("composer");
            w.writeText(mojoDescriptor.getComponentComposer());
            w.endElement();
        }
        w.startElement("instantiationStrategy");
        w.writeText(mojoDescriptor.getInstantiationStrategy());
        w.endElement();
        w.startElement("executionStrategy");
        w.writeText(mojoDescriptor.getExecutionStrategy());
        w.endElement();
        List parameters = mojoDescriptor.getParameters();
        w.startElement("parameters");
        HashMap<String, Requirement> requirements = new HashMap<String, Requirement>();
        HashSet<Parameter> configuration = new HashSet<Parameter>();
        if (parameters != null) {
            for (int j = 0; j < parameters.size(); ++j) {
                parameter = (Parameter)parameters.get(j);
                String expression = parameter.getExpression();
                if (StringUtils.isNotEmpty((String)expression) && expression.startsWith("${component.")) {
                    String role = expression.substring("${component.".length(), expression.length() - 1);
                    String roleHint = null;
                    int posRoleHintSeparator = role.indexOf("#");
                    if (posRoleHintSeparator > 0) {
                        roleHint = role.substring(posRoleHintSeparator + 1);
                        role = role.substring(0, posRoleHintSeparator);
                    }
                    requirements.put(parameter.getName(), new Requirement(role, roleHint));
                    continue;
                }
                if (parameter.getRequirement() != null) {
                    requirements.put(parameter.getName(), parameter.getRequirement());
                    continue;
                }
                w.startElement("parameter");
                this.element(w, "name", parameter.getName());
                if (parameter.getAlias() != null) {
                    this.element(w, "alias", parameter.getAlias());
                }
                this.element(w, "type", parameter.getType());
                if (parameter.getDeprecated() != null) {
                    this.element(w, "deprecated", parameter.getDeprecated());
                }
                if (parameter.getImplementation() != null) {
                    this.element(w, "implementation", parameter.getImplementation());
                }
                this.element(w, "required", Boolean.toString(parameter.isRequired()));
                this.element(w, "editable", Boolean.toString(parameter.isEditable()));
                this.element(w, "description", parameter.getDescription());
                if (StringUtils.isNotEmpty((String)parameter.getDefaultValue()) || StringUtils.isNotEmpty((String)parameter.getExpression())) {
                    configuration.add(parameter);
                }
                w.endElement();
            }
        }
        w.endElement();
        if (!configuration.isEmpty()) {
            w.startElement("configuration");
            Iterator i = configuration.iterator();
            while (i.hasNext()) {
                parameter = (Parameter)i.next();
                w.startElement(parameter.getName());
                String type = parameter.getType();
                if (type != null) {
                    w.addAttribute("implementation", type);
                }
                if (parameter.getDefaultValue() != null) {
                    w.addAttribute("default-value", parameter.getDefaultValue());
                }
                if (parameter.getExpression() != null) {
                    w.writeText(parameter.getExpression());
                }
                w.endElement();
            }
            w.endElement();
        }
        if (!requirements.isEmpty()) {
            w.startElement("requirements");
            Iterator i = requirements.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Requirement requirement = (Requirement)requirements.get(key);
                w.startElement("requirement");
                this.element(w, "role", requirement.getRole());
                if (requirement.getRoleHint() != null) {
                    this.element(w, "role-hint", requirement.getRoleHint());
                }
                this.element(w, "field-name", key);
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }

    private void element(XMLWriter w, String name, String value) {
        PluginUtils.element(w, name, value);
    }
}

