/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.scanner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ComponentAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ExecuteAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.MojoAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.datamodel.ParameterAnnotationContent;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScanner;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotationsScannerRequest;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoAnnotationVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoClassVisitor;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.visitors.MojoFieldVisitor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.reflection.Reflector;
import org.codehaus.plexus.util.reflection.ReflectorException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

@Component(role=MojoAnnotationsScanner.class)
public class DefaultMojoAnnotationsScanner
extends AbstractLogEnabled
implements MojoAnnotationsScanner {
    private static final Pattern SCANNABLE_CLASS = Pattern.compile("[^-]+\\.class");
    private Reflector reflector = new Reflector();

    @Override
    public Map<String, MojoAnnotatedClass> scan(MojoAnnotationsScannerRequest request) throws ExtractionException {
        HashMap<String, MojoAnnotatedClass> mojoAnnotatedClasses = new HashMap<String, MojoAnnotatedClass>();
        try {
            for (Artifact dependency : request.getDependencies()) {
                this.scan(mojoAnnotatedClasses, dependency.getFile(), request.getIncludePatterns(), dependency, true);
            }
            for (File classDirectory : request.getClassesDirectories()) {
                this.scan(mojoAnnotatedClasses, classDirectory, request.getIncludePatterns(), request.getProject().getArtifact(), false);
            }
        }
        catch (IOException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
        return mojoAnnotatedClasses;
    }

    protected void scan(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, File source, List<String> includePatterns, Artifact artifact, boolean excludeMojo) throws IOException, ExtractionException {
        if (source == null || !source.exists()) {
            return;
        }
        Map<String, MojoAnnotatedClass> scanResult = source.isDirectory() ? this.scanDirectory(source, includePatterns, artifact, excludeMojo) : this.scanArchive(source, artifact, excludeMojo);
        mojoAnnotatedClasses.putAll(scanResult);
    }

    protected Map<String, MojoAnnotatedClass> scanArchive(File archiveFile, Artifact artifact, boolean excludeMojo) throws IOException, ExtractionException {
        HashMap<String, MojoAnnotatedClass> mojoAnnotatedClasses = new HashMap<String, MojoAnnotatedClass>();
        String zipEntryName = null;
        try (ZipInputStream archiveStream = new ZipInputStream(new FileInputStream(archiveFile));){
            String archiveFilename = archiveFile.getAbsolutePath();
            ZipEntry zipEntry = archiveStream.getNextEntry();
            while (zipEntry != null) {
                zipEntryName = zipEntry.getName();
                if (SCANNABLE_CLASS.matcher(zipEntryName).matches()) {
                    this.analyzeClassStream(mojoAnnotatedClasses, archiveStream, artifact, excludeMojo, archiveFilename, zipEntry.getName());
                }
                zipEntry = archiveStream.getNextEntry();
            }
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Failed to analyze " + archiveFile.getAbsolutePath() + "!/" + zipEntryName);
            throw e;
        }
        return mojoAnnotatedClasses;
    }

    protected Map<String, MojoAnnotatedClass> scanDirectory(File classDirectory, List<String> includePatterns, Artifact artifact, boolean excludeMojo) throws IOException, ExtractionException {
        HashMap<String, MojoAnnotatedClass> mojoAnnotatedClasses = new HashMap<String, MojoAnnotatedClass>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classDirectory);
        scanner.addDefaultExcludes();
        if (includePatterns != null) {
            scanner.setIncludes(includePatterns.toArray(new String[includePatterns.size()]));
        }
        scanner.scan();
        String[] classFiles = scanner.getIncludedFiles();
        String classDirname = classDirectory.getAbsolutePath();
        for (String classFile : classFiles) {
            if (!SCANNABLE_CLASS.matcher(classFile).matches()) continue;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(classDirectory, classFile)));){
                this.analyzeClassStream(mojoAnnotatedClasses, is, artifact, excludeMojo, classDirname, classFile);
            }
        }
        return mojoAnnotatedClasses;
    }

    private void analyzeClassStream(Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, InputStream is, Artifact artifact, boolean excludeMojo, String source, String file) throws IOException, ExtractionException {
        MojoClassVisitor mojoClassVisitor = new MojoClassVisitor(this.getLogger());
        try {
            ClassReader rdr = new ClassReader(is);
            rdr.accept((ClassVisitor)mojoClassVisitor, 7);
        }
        catch (ArrayIndexOutOfBoundsException aiooe) {
            this.getLogger().warn("Error analyzing class " + file + " in " + source + ": ignoring class", (Throwable)(this.getLogger().isDebugEnabled() ? aiooe : null));
            return;
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage() == null) {
                this.getLogger().warn("Error analyzing class " + file + " in " + source + ": ignoring class", (Throwable)(this.getLogger().isDebugEnabled() ? iae : null));
                return;
            }
            throw iae;
        }
        this.analyzeVisitors(mojoClassVisitor);
        MojoAnnotatedClass mojoAnnotatedClass = mojoClassVisitor.getMojoAnnotatedClass();
        if (excludeMojo) {
            mojoAnnotatedClass.setMojo(null);
        }
        if (mojoAnnotatedClass != null) {
            if (this.getLogger().isDebugEnabled() && mojoAnnotatedClass.hasAnnotations()) {
                this.getLogger().debug("found MojoAnnotatedClass:" + mojoAnnotatedClass.getClassName() + ":" + mojoAnnotatedClass);
            }
            mojoAnnotatedClass.setArtifact(artifact);
            mojoAnnotatedClasses.put(mojoAnnotatedClass.getClassName(), mojoAnnotatedClass);
        }
    }

    protected void populateAnnotationContent(Object content, MojoAnnotationVisitor mojoAnnotationVisitor) throws ReflectorException {
        for (Map.Entry<String, Object> entry : mojoAnnotationVisitor.getAnnotationValues().entrySet()) {
            this.reflector.invoke(content, entry.getKey(), new Object[]{entry.getValue()});
        }
    }

    protected void analyzeVisitors(MojoClassVisitor mojoClassVisitor) throws ExtractionException {
        MojoAnnotatedClass mojoAnnotatedClass = mojoClassVisitor.getMojoAnnotatedClass();
        try {
            MojoAnnotationVisitor mojoAnnotationVisitor = mojoClassVisitor.getAnnotationVisitor(Mojo.class);
            if (mojoAnnotationVisitor != null) {
                MojoAnnotationContent mojoAnnotationContent = new MojoAnnotationContent();
                this.populateAnnotationContent(mojoAnnotationContent, mojoAnnotationVisitor);
                mojoAnnotatedClass.setMojo(mojoAnnotationContent);
            }
            if ((mojoAnnotationVisitor = mojoClassVisitor.getAnnotationVisitor(Execute.class)) != null) {
                ExecuteAnnotationContent executeAnnotationContent = new ExecuteAnnotationContent();
                this.populateAnnotationContent(executeAnnotationContent, mojoAnnotationVisitor);
                mojoAnnotatedClass.setExecute(executeAnnotationContent);
            }
            List<MojoFieldVisitor> mojoFieldVisitors = mojoClassVisitor.findFieldWithAnnotation(Parameter.class);
            for (MojoFieldVisitor mojoFieldVisitor : mojoFieldVisitors) {
                ParameterAnnotationContent parameterAnnotationContent = new ParameterAnnotationContent(mojoFieldVisitor.getFieldName(), mojoFieldVisitor.getClassName());
                if (mojoFieldVisitor.getMojoAnnotationVisitor() != null) {
                    this.populateAnnotationContent(parameterAnnotationContent, mojoFieldVisitor.getMojoAnnotationVisitor());
                }
                mojoAnnotatedClass.getParameters().put(parameterAnnotationContent.getFieldName(), parameterAnnotationContent);
            }
            mojoFieldVisitors = mojoClassVisitor.findFieldWithAnnotation(org.apache.maven.plugins.annotations.Component.class);
            for (MojoFieldVisitor mojoFieldVisitor : mojoFieldVisitors) {
                ComponentAnnotationContent componentAnnotationContent = new ComponentAnnotationContent(mojoFieldVisitor.getFieldName());
                MojoAnnotationVisitor annotationVisitor = mojoFieldVisitor.getMojoAnnotationVisitor();
                if (annotationVisitor != null) {
                    for (Map.Entry<String, Object> entry : annotationVisitor.getAnnotationValues().entrySet()) {
                        String methodName = entry.getKey();
                        if ("role".equals(methodName)) {
                            Type type = (Type)entry.getValue();
                            componentAnnotationContent.setRoleClassName(type.getClassName());
                            continue;
                        }
                        this.reflector.invoke((Object)componentAnnotationContent, entry.getKey(), new Object[]{entry.getValue()});
                    }
                    if (StringUtils.isEmpty((String)componentAnnotationContent.getRoleClassName())) {
                        componentAnnotationContent.setRoleClassName(mojoFieldVisitor.getClassName());
                    }
                }
                mojoAnnotatedClass.getComponents().put(componentAnnotationContent.getFieldName(), componentAnnotationContent);
            }
        }
        catch (ReflectorException e) {
            throw new ExtractionException(e.getMessage(), (Throwable)e);
        }
    }
}

