/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.codehaus.plexus.util.PathTool;
import org.codehaus.plexus.util.StringUtils;

public class DocumentRenderingContext {
    private final File basedir;
    private final String basedirRelativePath;
    private final String inputName;
    private final String outputName;
    private final String parserId;
    private final String relativePath;
    private final String extension;
    private Map<String, String> attributes;
    private final boolean editable;
    private final String generator;

    public DocumentRenderingContext(File basedir, String document, String generator) {
        this(basedir, null, document, null, null, false, generator);
    }

    public DocumentRenderingContext(File basedir, String basedirRelativePath, String document, String parserId, String extension, boolean editable) {
        this(basedir, basedirRelativePath, document, parserId, extension, editable, null);
    }

    public DocumentRenderingContext(File basedir, String basedirRelativePath, String document, String parserId, String extension, boolean editable, String generator) {
        this.basedir = basedir;
        this.basedirRelativePath = basedirRelativePath;
        this.inputName = document;
        this.parserId = parserId;
        this.extension = extension;
        this.generator = generator;
        this.attributes = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)extension)) {
            this.editable = editable;
            if (DefaultSiteRenderer.endsWithIgnoreCase(document, ".vm")) {
                document = document.substring(0, document.length() - 3);
            }
            String fileNameWithoutExt = document.substring(0, document.length() - extension.length() - 1);
            this.outputName = fileNameWithoutExt + ".html";
        } else {
            this.editable = false;
            this.outputName = document.substring(0, document.lastIndexOf(46)).replace('\\', '/') + ".html";
        }
        this.relativePath = PathTool.getRelativePath((String)basedir.getPath(), (String)new File(basedir, this.inputName).getPath());
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String getInputName() {
        return this.inputName;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getParserId() {
        return this.parserId;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDoxiaSource() {
        return StringUtils.isNotEmpty((String)this.extension);
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getBasedirRelativePath() {
        return this.basedirRelativePath;
    }

    public String getDoxiaSourcePath() {
        return this.isDoxiaSource() ? this.basedirRelativePath + '/' + this.inputName : null;
    }

    public String getDoxiaSourcePath(String base) {
        return PathTool.calculateLink((String)this.getDoxiaSourcePath(), (String)base);
    }
}

