/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer.sink;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.module.xhtml5.Xhtml5Sink;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class SiteRendererSink
extends Xhtml5Sink
implements DocumentContent {
    private String date;
    private String title;
    private List<String> authors = new ArrayList<String>();
    private final StringWriter headWriter;
    private final Writer writer;
    private RenderingContext renderingContext;

    public SiteRendererSink(RenderingContext renderingContext) {
        this(new StringWriter(), renderingContext);
    }

    private SiteRendererSink(StringWriter writer, RenderingContext renderingContext) {
        super((Writer)writer);
        this.writer = writer;
        this.headWriter = new StringWriter();
        this.renderingContext = renderingContext;
        this.contentStack.push(HtmlMarkup.MAIN);
    }

    public void title_() {
        if (this.getTextBuffer().length() > 0) {
            this.title = this.getTextBuffer().toString();
        }
        this.resetTextBuffer();
    }

    public void title() {
        this.resetTextBuffer();
    }

    public void author() {
        this.resetTextBuffer();
    }

    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            String text = HtmlTools.escapeHTML((String)this.getTextBuffer().toString());
            text = StringUtils.replace((String)text, (String)"&amp;#", (String)"&#");
            this.authors.add(text.trim());
        }
        this.resetTextBuffer();
    }

    public void date() {
        this.resetTextBuffer();
    }

    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.date = this.getTextBuffer().toString().trim();
        }
        this.resetTextBuffer();
    }

    public void body_() {
    }

    public void body() {
    }

    public void head_() {
        this.setHeadFlag(false);
    }

    public void head() {
        this.setHeadFlag(true);
    }

    protected void write(String text) {
        String txt = text;
        if (this.isHeadFlag()) {
            this.headWriter.write(SiteRendererSink.unifyEOLs((String)txt));
            return;
        }
        if (this.renderingContext != null) {
            String relativePathToBasedir = this.renderingContext.getRelativePath();
            txt = relativePathToBasedir == null ? StringUtils.replace((String)txt, (String)"$relativePath", (String)".") : StringUtils.replace((String)txt, (String)"$relativePath", (String)relativePathToBasedir);
        }
        super.write(txt);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<String> getAuthors() {
        return this.authors;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getBody() {
        String body = this.writer.toString();
        return body.length() > 0 ? body : null;
    }

    @Override
    public String getHead() {
        String head = this.headWriter.toString();
        return head.length() > 0 ? head : null;
    }

    @Override
    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }
}

