/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Point;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.spatial.vector.PointVectorStrategy;
import org.apache.lucene.util.Bits;

public class DistanceValueSource
extends ValueSource {
    private PointVectorStrategy strategy;
    private final Point from;

    public DistanceValueSource(PointVectorStrategy strategy, Point from) {
        this.strategy = strategy;
        this.from = from;
    }

    public String description() {
        return "DistanceValueSource(" + this.strategy + ", " + this.from + ")";
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        AtomicReader reader = readerContext.reader();
        final FieldCache.Doubles ptX = FieldCache.DEFAULT.getDoubles(reader, this.strategy.getFieldNameX(), true);
        final FieldCache.Doubles ptY = FieldCache.DEFAULT.getDoubles(reader, this.strategy.getFieldNameY(), true);
        final Bits validX = FieldCache.DEFAULT.getDocsWithField(reader, this.strategy.getFieldNameX());
        final Bits validY = FieldCache.DEFAULT.getDocsWithField(reader, this.strategy.getFieldNameY());
        return new FunctionValues(){
            private final Point from;
            private final DistanceCalculator calculator;
            private final double nullValue;
            {
                this.from = DistanceValueSource.this.from;
                this.calculator = DistanceValueSource.this.strategy.getSpatialContext().getDistCalc();
                this.nullValue = DistanceValueSource.this.strategy.getSpatialContext().isGeo() ? 180.0 : Double.MAX_VALUE;
            }

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                if (validX.get(doc)) {
                    assert (validY.get(doc));
                    return this.calculator.distance(this.from, ptX.get(doc), ptY.get(doc));
                }
                return this.nullValue;
            }

            public String toString(int doc) {
                return DistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceValueSource that = (DistanceValueSource)((Object)o);
        if (!this.from.equals(that.from)) {
            return false;
        }
        return this.strategy.equals(that.strategy);
    }

    public int hashCode() {
        return this.from.hashCode();
    }
}

