/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.search.intervals.DifferenceIntervalsSource;
import org.apache.lucene.search.intervals.Disjunctions;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.Intervals;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.search.intervals.RelativeIterator;

class NotContainingIntervalsSource
extends DifferenceIntervalsSource {
    static IntervalsSource build(IntervalsSource minuend, IntervalsSource subtrahend) {
        return Intervals.or(Disjunctions.pullUp(minuend, s -> new NotContainingIntervalsSource((IntervalsSource)s, subtrahend)));
    }

    private NotContainingIntervalsSource(IntervalsSource minuend, IntervalsSource subtrahend) {
        super(minuend, subtrahend);
    }

    @Override
    protected IntervalIterator combine(IntervalIterator minuend, IntervalIterator subtrahend) {
        return new NotContainingIterator(minuend, subtrahend);
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singletonList(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minuend, this.subtrahend);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NotContainingIntervalsSource)) {
            return false;
        }
        NotContainingIntervalsSource o = (NotContainingIntervalsSource)other;
        return Objects.equals(this.minuend, o.minuend) && Objects.equals(this.subtrahend, o.subtrahend);
    }

    @Override
    public String toString() {
        return "NOT_CONTAINING(" + this.minuend + "," + this.subtrahend + ")";
    }

    private static class NotContainingIterator
    extends RelativeIterator {
        private NotContainingIterator(IntervalIterator minuend, IntervalIterator subtrahend) {
            super(minuend, subtrahend);
        }

        @Override
        public int nextInterval() throws IOException {
            if (!this.bpos) {
                return this.a.nextInterval();
            }
            while (this.a.nextInterval() != Integer.MAX_VALUE) {
                while (this.b.start() < this.a.start() && this.b.end() < this.a.end()) {
                    if (this.b.nextInterval() != Integer.MAX_VALUE) continue;
                    this.bpos = false;
                    return this.a.start();
                }
                if (this.b.start() <= this.a.end()) continue;
                return this.a.start();
            }
            return Integer.MAX_VALUE;
        }
    }
}

