/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Line2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonShapeLineQuery
extends LatLonShapeQuery {
    final Line[] lines;
    private final Line2D line2D;

    public LatLonShapeLineQuery(String field, LatLonShape.QueryRelation queryRelation, Line ... lines) {
        super(field, queryRelation);
        if (queryRelation == LatLonShape.QueryRelation.WITHIN) {
            throw new IllegalArgumentException("LatLonShapeLineQuery does not support " + (Object)((Object)LatLonShape.QueryRelation.WITHIN) + " queries");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines must not be null");
        }
        if (lines.length == 0) {
            throw new IllegalArgumentException("lines must not be empty");
        }
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) {
                throw new IllegalArgumentException("line[" + i + "] must not be null");
            }
            if (!(lines[i].minLon > lines[i].maxLon)) continue;
            throw new IllegalArgumentException("LatLonShapeLineQuery does not currently support querying across dateline.");
        }
        this.lines = (Line[])lines.clone();
        this.line2D = Line2D.create(lines);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = GeoEncodingUtils.decodeLatitude((int)NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minYOffset));
        double minLon = GeoEncodingUtils.decodeLongitude((int)NumericUtils.sortableBytesToInt((byte[])minTriangle, (int)minXOffset));
        double maxLat = GeoEncodingUtils.decodeLatitude((int)NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxYOffset));
        double maxLon = GeoEncodingUtils.decodeLongitude((int)NumericUtils.sortableBytesToInt((byte[])maxTriangle, (int)maxXOffset));
        return this.line2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] t, int[] scratchTriangle, LatLonShape.QueryRelation queryRelation) {
        LatLonShape.decodeTriangle(t, scratchTriangle);
        double alat = GeoEncodingUtils.decodeLatitude((int)scratchTriangle[0]);
        double alon = GeoEncodingUtils.decodeLongitude((int)scratchTriangle[1]);
        double blat = GeoEncodingUtils.decodeLatitude((int)scratchTriangle[2]);
        double blon = GeoEncodingUtils.decodeLongitude((int)scratchTriangle[3]);
        double clat = GeoEncodingUtils.decodeLatitude((int)scratchTriangle[4]);
        double clon = GeoEncodingUtils.decodeLongitude((int)scratchTriangle[5]);
        if (queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Line(" + this.lines[0].toGeoJSON() + ")");
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.lines, ((LatLonShapeLineQuery)((Object)o)).lines);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.lines);
        return hash;
    }
}

