/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.codecs.idversion.VersionFieldReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.PairOutputs;

final class VersionBlockTreeTermsReader
extends FieldsProducer {
    final IndexInput in;
    final PostingsReaderBase postingsReader;
    private final TreeMap<String, VersionFieldReader> fields = new TreeMap();
    private long dirOffset;
    private long indexDirOffset;
    final String segment;
    private final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VersionBlockTreeTermsReader(Directory dir, FieldInfos fieldInfos, SegmentInfo info, PostingsReaderBase postingsReader, IOContext ioContext, String segmentSuffix) throws IOException {
        this.postingsReader = postingsReader;
        this.segment = info.name;
        this.in = dir.openInput(IndexFileNames.segmentFileName((String)this.segment, (String)segmentSuffix, (String)"tiv"), ioContext);
        boolean success = false;
        IndexInput indexIn = null;
        try {
            this.version = this.readHeader(this.in);
            indexIn = dir.openInput(IndexFileNames.segmentFileName((String)this.segment, (String)segmentSuffix, (String)"tipv"), ioContext);
            int indexVersion = this.readIndexHeader(indexIn);
            if (indexVersion != this.version) {
                throw new CorruptIndexException("mixmatched version files: " + this.in + "=" + this.version + "," + indexIn + "=" + indexVersion);
            }
            CodecUtil.checksumEntireFile((IndexInput)indexIn);
            postingsReader.init(this.in);
            this.seekDir(this.in, this.dirOffset);
            this.seekDir(indexIn, this.indexDirOffset);
            int numFields = this.in.readVInt();
            if (numFields < 0) {
                throw new CorruptIndexException("invalid numFields: " + numFields + " (resource=" + this.in + ")");
            }
            for (int i = 0; i < numFields; ++i) {
                int field = this.in.readVInt();
                long numTerms = this.in.readVLong();
                assert (numTerms >= 0L);
                int numBytes = this.in.readVInt();
                BytesRef code = new BytesRef(new byte[numBytes]);
                this.in.readBytes(code.bytes, 0, numBytes);
                code.length = numBytes;
                long version = this.in.readVLong();
                PairOutputs.Pair rootCode = VersionBlockTreeTermsWriter.FST_OUTPUTS.newPair((Object)code, (Object)version);
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                assert (fieldInfo != null) : "field=" + field;
                long sumTotalTermFreq = numTerms;
                long sumDocFreq = numTerms;
                assert (numTerms <= Integer.MAX_VALUE);
                int docCount = (int)numTerms;
                int longsSize = this.in.readVInt();
                BytesRef minTerm = VersionBlockTreeTermsReader.readBytesRef(this.in);
                BytesRef maxTerm = VersionBlockTreeTermsReader.readBytesRef(this.in);
                if (docCount < 0 || docCount > info.getDocCount()) {
                    throw new CorruptIndexException("invalid docCount: " + docCount + " maxDoc: " + info.getDocCount() + " (resource=" + this.in + ")");
                }
                if (sumDocFreq < (long)docCount) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + sumDocFreq + " docCount: " + docCount + " (resource=" + this.in + ")");
                }
                if (sumTotalTermFreq != -1L && sumTotalTermFreq < sumDocFreq) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + sumTotalTermFreq + " sumDocFreq: " + sumDocFreq + " (resource=" + this.in + ")");
                }
                long indexStartFP = indexIn.readVLong();
                VersionFieldReader previous = this.fields.put(fieldInfo.name, new VersionFieldReader(this, fieldInfo, numTerms, (PairOutputs.Pair<BytesRef, Long>)rootCode, sumTotalTermFreq, sumDocFreq, docCount, indexStartFP, longsSize, indexIn, minTerm, maxTerm));
                if (previous == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name + " (resource=" + this.in + ")");
            }
            indexIn.close();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexIn, this});
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput in) throws IOException {
        BytesRef bytes = new BytesRef();
        bytes.length = in.readVInt();
        bytes.bytes = new byte[bytes.length];
        in.readBytes(bytes.bytes, 0, bytes.length);
        return bytes;
    }

    private int readHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)input, (String)"VERSION_BLOCK_TREE_TERMS_DICT", (int)0, (int)0);
        return version;
    }

    private int readIndexHeader(IndexInput input) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)input, (String)"VERSION_BLOCK_TREE_TERMS_INDEX", (int)0, (int)0);
        return version;
    }

    private void seekDir(IndexInput input, long dirOffset) throws IOException {
        input.seek(input.length() - (long)CodecUtil.footerLength() - 8L);
        dirOffset = input.readLong();
        input.seek(dirOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.in, this.postingsReader});
        }
        finally {
            this.fields.clear();
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public Terms terms(String field) throws IOException {
        assert (field != null);
        return this.fields.get(field);
    }

    public int size() {
        return this.fields.size();
    }

    String brToString(BytesRef b) {
        if (b == null) {
            return "null";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    public long ramBytesUsed() {
        long sizeInByes = this.postingsReader != null ? this.postingsReader.ramBytesUsed() : 0L;
        for (VersionFieldReader reader : this.fields.values()) {
            sizeInByes += reader.ramBytesUsed();
        }
        return sizeInByes;
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.in);
        this.postingsReader.checkIntegrity();
    }
}

