/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.MetadataVersionValidator;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;

public class LogConfig
extends AbstractConfig {
    public static final String SERVER_DEFAULT_HEADER_NAME = "Server Default Property";
    public static final int DEFAULT_MAX_MESSAGE_BYTES = 0x10000C;
    public static final int DEFAULT_SEGMENT_BYTES = 0x40000000;
    public static final long DEFAULT_SEGMENT_MS = 604800000L;
    public static final long DEFAULT_SEGMENT_JITTER_MS = 0L;
    public static final long DEFAULT_RETENTION_MS = 604800000L;
    public static final long DEFAULT_RETENTION_BYTES = -1L;
    public static final int DEFAULT_SEGMENT_INDEX_BYTES = 0xA00000;
    public static final int DEFAULT_INDEX_INTERVAL_BYTES = 4096;
    public static final long DEFAULT_FILE_DELETE_DELAY_MS = 60000L;
    public static final String DEFAULT_CLEANUP_POLICY = "delete";
    public static final long DEFAULT_FLUSH_MESSAGES_INTERVAL = Long.MAX_VALUE;
    public static final long DEFAULT_FLUSH_MS = Long.MAX_VALUE;
    public static final long DEFAULT_DELETE_RETENTION_MS = 86400000L;
    public static final long DEFAULT_MIN_COMPACTION_LAG_MS = 0L;
    public static final long DEFAULT_MAX_COMPACTION_LAG_MS = Long.MAX_VALUE;
    public static final double DEFAULT_MIN_CLEANABLE_DIRTY_RATIO = 0.5;
    public static final boolean DEFAULT_UNCLEAN_LEADER_ELECTION_ENABLE = false;
    public static final int DEFAULT_MIN_IN_SYNC_REPLICAS = 1;
    public static final String DEFAULT_COMPRESSION_TYPE = BrokerCompressionType.PRODUCER.name;
    public static final boolean DEFAULT_PREALLOCATE = false;
    public static final String DEFAULT_MESSAGE_TIMESTAMP_TYPE = "CreateTime";
    @Deprecated
    public static final long DEFAULT_MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS = Long.MAX_VALUE;
    public static final long DEFAULT_MESSAGE_TIMESTAMP_BEFORE_MAX_MS = Long.MAX_VALUE;
    public static final long DEFAULT_MESSAGE_TIMESTAMP_AFTER_MAX_MS = Long.MAX_VALUE;
    public static final boolean DEFAULT_MESSAGE_DOWNCONVERSION_ENABLE = true;
    public static final boolean DEFAULT_REMOTE_STORAGE_ENABLE = false;
    public static final long DEFAULT_LOCAL_RETENTION_BYTES = -2L;
    public static final long DEFAULT_LOCAL_RETENTION_MS = -2L;
    public static final List<String> DEFAULT_LEADER_REPLICATION_THROTTLED_REPLICAS = Collections.emptyList();
    public static final List<String> DEFAULT_FOLLOWER_REPLICATION_THROTTLED_REPLICAS = Collections.emptyList();
    @Deprecated
    public static final String DEFAULT_MESSAGE_FORMAT_VERSION = MetadataVersion.IBP_3_0_IV1.version();
    public static final String LEADER_REPLICATION_THROTTLED_REPLICAS_CONFIG = "leader.replication.throttled.replicas";
    public static final String FOLLOWER_REPLICATION_THROTTLED_REPLICAS_CONFIG = "follower.replication.throttled.replicas";
    private static final String MESSAGE_FORMAT_VERSION_CONFIG = "message.format.version";
    private static final String MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_CONFIG = "message.timestamp.difference.max.ms";
    private static final String MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_DOC = "[DEPRECATED] The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message. If message.timestamp.type=CreateTime, a message will be rejected if the difference in timestamp exceeds this threshold. This configuration is ignored if message.timestamp.type=LogAppendTime.";
    public static final Set<String> CONFIGS_WITH_NO_SERVER_DEFAULTS = Collections.unmodifiableSet(Utils.mkSet((Object[])new String[]{"remote.storage.enable", "leader.replication.throttled.replicas", "follower.replication.throttled.replicas"}));
    public static final String LEADER_REPLICATION_THROTTLED_REPLICAS_DOC = "A list of replicas for which log replication should be throttled on the leader side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
    public static final String FOLLOWER_REPLICATION_THROTTLED_REPLICAS_DOC = "A list of replicas for which log replication should be throttled on the follower side. The list should describe a set of replicas in the form [PartitionId]:[BrokerId],[PartitionId]:[BrokerId]:... or alternatively the wildcard '*' can be used to throttle all replicas for this topic.";
    private static final String MESSAGE_FORMAT_VERSION_DOC = "[DEPRECATED] Specify the message format version the broker will use to append messages to the logs. The value of this config is always assumed to be `3.0` if `inter.broker.protocol.version` is 3.0 or higher (the actual config value is ignored). Otherwise, the value should be a valid ApiVersion. Some examples are: 0.10.0, 1.1, 2.8, 3.0. By setting a particular message format version, the user is certifying that all the existing messages on disk are smaller or equal than the specified version. Setting this value incorrectly will cause consumers with older versions to break as they will receive messages with a format that they don't understand.";
    private static final LogConfigDef CONFIG = new LogConfigDef();
    public final Set<String> overriddenConfigs;
    public final int segmentSize;
    public final long segmentMs;
    public final long segmentJitterMs;
    public final int maxIndexSize;
    public final long flushInterval;
    public final long flushMs;
    public final long retentionSize;
    public final long retentionMs;
    public final int indexInterval;
    public final long fileDeleteDelayMs;
    public final long deleteRetentionMs;
    public final long compactionLagMs;
    public final long maxCompactionLagMs;
    public final double minCleanableRatio;
    public final boolean compact;
    public final boolean delete;
    public final boolean uncleanLeaderElectionEnable;
    public final int minInSyncReplicas;
    public final String compressionType;
    public final boolean preallocate;
    @Deprecated
    public final MetadataVersion messageFormatVersion;
    public final TimestampType messageTimestampType;
    @Deprecated
    public final long messageTimestampDifferenceMaxMs;
    public final long messageTimestampBeforeMaxMs;
    public final long messageTimestampAfterMaxMs;
    public final List<String> leaderReplicationThrottledReplicas;
    public final List<String> followerReplicationThrottledReplicas;
    public final boolean messageDownConversionEnable;
    public final RemoteLogConfig remoteLogConfig;
    private final int maxMessageSize;
    private final Map<?, ?> props;

    public LogConfig(Map<?, ?> props) {
        this(props, Collections.emptySet());
    }

    public LogConfig(Map<?, ?> props, Set<String> overriddenConfigs) {
        super((ConfigDef)CONFIG, props, false);
        this.props = Collections.unmodifiableMap(props);
        this.overriddenConfigs = Collections.unmodifiableSet(overriddenConfigs);
        this.segmentSize = this.getInt("segment.bytes");
        this.segmentMs = this.getLong("segment.ms");
        this.segmentJitterMs = this.getLong("segment.jitter.ms");
        this.maxIndexSize = this.getInt("segment.index.bytes");
        this.flushInterval = this.getLong("flush.messages");
        this.flushMs = this.getLong("flush.ms");
        this.retentionSize = this.getLong("retention.bytes");
        this.retentionMs = this.getLong("retention.ms");
        this.maxMessageSize = this.getInt("max.message.bytes");
        this.indexInterval = this.getInt("index.interval.bytes");
        this.fileDeleteDelayMs = this.getLong("file.delete.delay.ms");
        this.deleteRetentionMs = this.getLong("delete.retention.ms");
        this.compactionLagMs = this.getLong("min.compaction.lag.ms");
        this.maxCompactionLagMs = this.getLong("max.compaction.lag.ms");
        this.minCleanableRatio = this.getDouble("min.cleanable.dirty.ratio");
        this.compact = this.getList("cleanup.policy").stream().map(c -> c.toLowerCase(Locale.ROOT)).collect(Collectors.toList()).contains("compact");
        this.delete = this.getList("cleanup.policy").stream().map(c -> c.toLowerCase(Locale.ROOT)).collect(Collectors.toList()).contains(DEFAULT_CLEANUP_POLICY);
        this.uncleanLeaderElectionEnable = this.getBoolean("unclean.leader.election.enable");
        this.minInSyncReplicas = this.getInt("min.insync.replicas");
        this.compressionType = this.getString("compression.type").toLowerCase(Locale.ROOT);
        this.preallocate = this.getBoolean("preallocate");
        this.messageFormatVersion = MetadataVersion.fromVersionString((String)this.getString(MESSAGE_FORMAT_VERSION_CONFIG));
        this.messageTimestampType = TimestampType.forName((String)this.getString("message.timestamp.type"));
        this.messageTimestampDifferenceMaxMs = this.getLong(MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_CONFIG);
        this.messageTimestampBeforeMaxMs = this.getMessageTimestampBeforeMaxMs();
        this.messageTimestampAfterMaxMs = this.getMessageTimestampAfterMaxMs();
        this.leaderReplicationThrottledReplicas = Collections.unmodifiableList(this.getList(LEADER_REPLICATION_THROTTLED_REPLICAS_CONFIG));
        this.followerReplicationThrottledReplicas = Collections.unmodifiableList(this.getList(FOLLOWER_REPLICATION_THROTTLED_REPLICAS_CONFIG));
        this.messageDownConversionEnable = this.getBoolean("message.downconversion.enable");
        this.remoteLogConfig = new RemoteLogConfig(this);
    }

    private long getMessageTimestampBeforeMaxMs() {
        Long messageTimestampBeforeMaxMs = this.getLong("message.timestamp.before.max.ms");
        if (!messageTimestampBeforeMaxMs.equals(Long.MAX_VALUE)) {
            return messageTimestampBeforeMaxMs;
        }
        return this.messageTimestampDifferenceMaxMs;
    }

    private long getMessageTimestampAfterMaxMs() {
        Long messageTimestampAfterMaxMs = this.getLong("message.timestamp.after.max.ms");
        if (!messageTimestampAfterMaxMs.equals(Long.MAX_VALUE)) {
            return messageTimestampAfterMaxMs;
        }
        return this.messageTimestampDifferenceMaxMs;
    }

    public RecordVersion recordVersion() {
        return this.messageFormatVersion.highestSupportedRecordVersion();
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public long randomSegmentJitter() {
        if (this.segmentJitterMs == 0L) {
            return 0L;
        }
        return (long)Utils.abs((int)ThreadLocalRandom.current().nextInt()) % Math.min(this.segmentJitterMs, this.segmentMs);
    }

    public long maxSegmentMs() {
        if (this.compact && this.maxCompactionLagMs > 0L) {
            return Math.min(this.maxCompactionLagMs, this.segmentMs);
        }
        return this.segmentMs;
    }

    public int initFileSize() {
        if (this.preallocate) {
            return this.segmentSize;
        }
        return 0;
    }

    public boolean remoteStorageEnable() {
        return this.remoteLogConfig.remoteStorageEnable;
    }

    public long localRetentionMs() {
        return this.remoteLogConfig.localRetentionMs == -2L ? this.retentionMs : this.remoteLogConfig.localRetentionMs;
    }

    public long localRetentionBytes() {
        return this.remoteLogConfig.localRetentionBytes == -2L ? this.retentionSize : this.remoteLogConfig.localRetentionBytes;
    }

    public String overriddenConfigsAsLoggableString() {
        HashMap overriddenTopicProps = new HashMap();
        this.props.forEach((k, v) -> {
            if (this.overriddenConfigs.contains(k)) {
                overriddenTopicProps.put((String)k, v);
            }
        });
        return ConfigUtils.configMapToRedactedString(overriddenTopicProps, (ConfigDef)CONFIG);
    }

    public static LogConfig fromProps(Map<?, ?> defaults, Properties overrides) {
        Properties props = new Properties();
        defaults.forEach((k, v) -> props.put(k, v));
        props.putAll((Map<?, ?>)overrides);
        Set<String> overriddenKeys = overrides.keySet().stream().map(k -> (String)k).collect(Collectors.toSet());
        return new LogConfig(props, overriddenKeys);
    }

    public static LogConfigDef configDefCopy() {
        return new LogConfigDef(CONFIG);
    }

    public static boolean shouldIgnoreMessageFormatVersion(MetadataVersion interBrokerProtocolVersion) {
        return interBrokerProtocolVersion.isAtLeast(MetadataVersion.IBP_3_0_IV1);
    }

    public static Optional<ConfigDef.Type> configType(String configName) {
        return Optional.ofNullable(CONFIG.configKeys().get(configName)).map(c -> c.type);
    }

    public static List<String> configNames() {
        return CONFIG.names().stream().sorted().collect(Collectors.toList());
    }

    public static Optional<String> serverConfigName(String configName) {
        return CONFIG.serverConfigName(configName);
    }

    public static Map<String, ConfigDef.ConfigKey> configKeys() {
        return Collections.unmodifiableMap(CONFIG.configKeys());
    }

    public static void validateNames(Properties props) {
        List<String> names = LogConfig.configNames();
        for (Object name : props.keySet()) {
            if (names.contains(name)) continue;
            throw new InvalidConfigurationException("Unknown topic config name: " + name);
        }
    }

    public static void validateValues(Map<?, ?> props) {
        long maxCompactionLag;
        long minCompactionLag = (Long)props.get("min.compaction.lag.ms");
        if (minCompactionLag > (maxCompactionLag = ((Long)props.get("max.compaction.lag.ms")).longValue())) {
            throw new InvalidConfigurationException("conflict topic config setting min.compaction.lag.ms (" + minCompactionLag + ") > " + "max.compaction.lag.ms" + " (" + maxCompactionLag + ")");
        }
    }

    public static void validateBrokerLogConfigValues(Map<?, ?> props, boolean isRemoteLogStorageSystemEnabled) {
        LogConfig.validateValues(props);
        if (isRemoteLogStorageSystemEnabled) {
            LogConfig.validateRemoteStorageRetentionSize(props);
            LogConfig.validateRemoteStorageRetentionTime(props);
        }
    }

    private static void validateTopicLogConfigValues(Map<?, ?> props, boolean isRemoteLogStorageSystemEnabled) {
        LogConfig.validateValues(props);
        boolean isRemoteLogStorageEnabled = (Boolean)props.get("remote.storage.enable");
        if (isRemoteLogStorageEnabled) {
            LogConfig.validateRemoteStorageOnlyIfSystemEnabled(props, isRemoteLogStorageSystemEnabled, false);
            LogConfig.validateNoRemoteStorageForCompactedTopic(props);
            LogConfig.validateRemoteStorageRetentionSize(props);
            LogConfig.validateRemoteStorageRetentionTime(props);
        }
    }

    public static void validateRemoteStorageOnlyIfSystemEnabled(Map<?, ?> props, boolean isRemoteLogStorageSystemEnabled, boolean isReceivingConfigFromStore) {
        boolean isRemoteLogStorageEnabled = (Boolean)props.get("remote.storage.enable");
        if (isRemoteLogStorageEnabled && !isRemoteLogStorageSystemEnabled) {
            if (isReceivingConfigFromStore) {
                throw new ConfigException("You have to delete all topics with the property remote.storage.enable=true before disabling tiered storage cluster-wide");
            }
            throw new ConfigException("Tiered Storage functionality is disabled in the broker. Topic cannot be configured with remote log storage.");
        }
    }

    private static void validateNoRemoteStorageForCompactedTopic(Map<?, ?> props) {
        String cleanupPolicy = props.get("cleanup.policy").toString().toLowerCase(Locale.getDefault());
        if (cleanupPolicy.contains("compact")) {
            throw new ConfigException("Remote log storage is unsupported for the compacted topics");
        }
    }

    private static void validateRemoteStorageRetentionSize(Map<?, ?> props) {
        Long retentionBytes = (Long)props.get("retention.bytes");
        Long localRetentionBytes = (Long)props.get("local.retention.bytes");
        if (retentionBytes > -1L && localRetentionBytes != -2L) {
            if (localRetentionBytes == -1L) {
                String message = String.format("Value must not be -1 as %s value is set as %d.", "retention.bytes", retentionBytes);
                throw new ConfigException("local.retention.bytes", (Object)localRetentionBytes, message);
            }
            if (localRetentionBytes > retentionBytes) {
                String message = String.format("Value must not be more than %s property value: %d", "retention.bytes", retentionBytes);
                throw new ConfigException("local.retention.bytes", (Object)localRetentionBytes, message);
            }
        }
    }

    private static void validateRemoteStorageRetentionTime(Map<?, ?> props) {
        Long retentionMs = (Long)props.get("retention.ms");
        Long localRetentionMs = (Long)props.get("local.retention.ms");
        if (retentionMs != -1L && localRetentionMs != -2L) {
            if (localRetentionMs == -1L) {
                String message = String.format("Value must not be -1 as %s value is set as %d.", "retention.ms", retentionMs);
                throw new ConfigException("local.retention.ms", (Object)localRetentionMs, message);
            }
            if (localRetentionMs > retentionMs) {
                String message = String.format("Value must not be more than %s property value: %d", "retention.ms", retentionMs);
                throw new ConfigException("local.retention.ms", (Object)localRetentionMs, message);
            }
        }
    }

    public static void validate(Properties props) {
        LogConfig.validate(props, Collections.emptyMap(), false);
    }

    public static void validate(Properties props, Map<?, ?> configuredProps, boolean isRemoteLogStorageSystemEnabled) {
        LogConfig.validateNames(props);
        if (configuredProps == null || configuredProps.isEmpty()) {
            Map valueMaps = CONFIG.parse(props);
            LogConfig.validateValues(valueMaps);
        } else {
            HashMap combinedConfigs = new HashMap(configuredProps);
            combinedConfigs.putAll(props);
            Map valueMaps = CONFIG.parse(combinedConfigs);
            LogConfig.validateTopicLogConfigValues(valueMaps, isRemoteLogStorageSystemEnabled);
        }
    }

    public String toString() {
        return "LogConfig{segmentSize=" + this.segmentSize + ", segmentMs=" + this.segmentMs + ", segmentJitterMs=" + this.segmentJitterMs + ", maxIndexSize=" + this.maxIndexSize + ", flushInterval=" + this.flushInterval + ", flushMs=" + this.flushMs + ", retentionSize=" + this.retentionSize + ", retentionMs=" + this.retentionMs + ", indexInterval=" + this.indexInterval + ", fileDeleteDelayMs=" + this.fileDeleteDelayMs + ", deleteRetentionMs=" + this.deleteRetentionMs + ", compactionLagMs=" + this.compactionLagMs + ", maxCompactionLagMs=" + this.maxCompactionLagMs + ", minCleanableRatio=" + this.minCleanableRatio + ", compact=" + this.compact + ", delete=" + this.delete + ", uncleanLeaderElectionEnable=" + this.uncleanLeaderElectionEnable + ", minInSyncReplicas=" + this.minInSyncReplicas + ", compressionType='" + this.compressionType + '\'' + ", preallocate=" + this.preallocate + ", messageFormatVersion=" + this.messageFormatVersion + ", messageTimestampType=" + this.messageTimestampType + ", messageTimestampDifferenceMaxMs=" + this.messageTimestampDifferenceMaxMs + ", leaderReplicationThrottledReplicas=" + this.leaderReplicationThrottledReplicas + ", followerReplicationThrottledReplicas=" + this.followerReplicationThrottledReplicas + ", messageDownConversionEnable=" + this.messageDownConversionEnable + ", remoteLogConfig=" + this.remoteLogConfig + ", maxMessageSize=" + this.maxMessageSize + '}';
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtml(4, config -> "topicconfigs_" + config));
    }

    static {
        CONFIG.define("segment.bytes", ConfigDef.Type.INT, 0x40000000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)14), ConfigDef.Importance.MEDIUM, "This configuration controls the segment file size for the log. Retention and cleaning is always done a file at a time so a larger segment size means fewer files but less granular control over retention.").define("segment.ms", ConfigDef.Type.LONG, (Object)604800000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "This configuration controls the period of time after which Kafka will force the log to roll even if the segment file isn't full to ensure that retention can delete or compact old data.").define("segment.jitter.ms", ConfigDef.Type.LONG, (Object)0L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The maximum random jitter subtracted from the scheduled segment roll time to avoid thundering herds of segment rolling").define("segment.index.bytes", ConfigDef.Type.INT, (Object)0xA00000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)4), ConfigDef.Importance.MEDIUM, "This configuration controls the size of the index that maps offsets to file positions. We preallocate this index file and shrink it only after log rolls. You generally should not need to change this setting.").define("flush.messages", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "This setting allows specifying an interval at which we will force an fsync of data written to the log. For example if this was set to 1 we would fsync after every message; if it were 5 we would fsync after every five messages. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient. This setting can be overridden on a per-topic basis (see <a href=\"#topicconfigs\">the per-topic configuration section</a>).").define("flush.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "This setting allows specifying a time interval at which we will force an fsync of data written to the log. For example if this was set to 1000 we would fsync after 1000 ms had passed. In general we recommend you not set this and use replication for durability and allow the operating system's background flush capabilities as it is more efficient.").define("retention.bytes", ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.MEDIUM, "This configuration controls the maximum size a partition (which consists of log segments) can grow to before we will discard old log segments to free up space if we are using the \"delete\" retention policy. By default there is no size limit only a time limit. Since this limit is enforced at the partition level, multiply it by the number of partitions to compute the topic retention in bytes.").define("retention.ms", ConfigDef.Type.LONG, (Object)604800000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "This configuration controls the maximum time we will retain a log before we will discard old log segments to free up space if we are using the \"delete\" retention policy. This represents an SLA on how soon consumers must read their data. If set to -1, no time limit is applied.").define("max.message.bytes", ConfigDef.Type.INT, (Object)0x10000C, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case.").define("index.interval.bytes", ConfigDef.Type.INT, (Object)4096, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "This setting controls how frequently Kafka adds an index entry to its offset index. The default setting ensures that we index a message roughly every 4096 bytes. More indexing allows reads to jump closer to the exact position in the log but makes the index larger. You probably don't need to change this.").define("delete.retention.ms", ConfigDef.Type.LONG, (Object)86400000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The amount of time to retain delete tombstone markers for <a href=\"#compaction\">log compacted</a> topics. This setting also gives a bound on the time in which a consumer must complete a read if they begin from offset 0 to ensure that they get a valid snapshot of the final stage (otherwise delete tombstones may be collected before they complete their scan).").define("min.compaction.lag.ms", ConfigDef.Type.LONG, (Object)0L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.").define("max.compaction.lag.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum time a message will remain ineligible for compaction in the log. Only applicable for logs that are being compacted.").define("file.delete.delay.ms", ConfigDef.Type.LONG, (Object)60000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The time to wait before deleting a file from the filesystem").define("min.cleanable.dirty.ratio", ConfigDef.Type.DOUBLE, (Object)0.5, (ConfigDef.Validator)ConfigDef.Range.between((Number)0, (Number)1), ConfigDef.Importance.MEDIUM, "This configuration controls how frequently the log compactor will attempt to clean the log (assuming <a href=\"#compaction\">log compaction</a> is enabled). By default we will avoid cleaning a log where more than 50% of the log has been compacted. This ratio bounds the maximum space wasted in the log by duplicates (at 50% at most 50% of the log could be duplicates). A higher ratio will mean fewer, more efficient cleanings but will mean more wasted space in the log. If the max.compaction.lag.ms or the min.compaction.lag.ms configurations are also specified, then the log compactor considers the log to be eligible for compaction as soon as either: (i) the dirty ratio threshold has been met and the log has had dirty (uncompacted) records for at least the min.compaction.lag.ms duration, or (ii) if the log has had dirty (uncompacted) records for at most the max.compaction.lag.ms period.").define("cleanup.policy", ConfigDef.Type.LIST, (Object)DEFAULT_CLEANUP_POLICY, (ConfigDef.Validator)ConfigDef.ValidList.in((String[])new String[]{"compact", DEFAULT_CLEANUP_POLICY}), ConfigDef.Importance.MEDIUM, "This config designates the retention policy to use on log segments. The \"delete\" policy (which is the default) will discard old segments when their retention time or size limit has been reached. The \"compact\" policy will enable <a href=\"#compaction\">log compaction</a>, which retains the latest value for each key. It is also possible to specify both policies in a comma-separated list (e.g. \"delete,compact\"). In this case, old segments will be discarded per the retention time and size configuration, while retained segments will be compacted.").define("unclean.leader.election.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Indicates whether to enable replicas not in the ISR set to be elected as leader as a last resort, even though doing so may result in data loss.").define("min.insync.replicas", ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "When a producer sets acks to \"all\" (or \"-1\"), this configuration specifies the minimum number of replicas that must acknowledge a write for the write to be considered successful. If this minimum cannot be met, then the producer will raise an exception (either NotEnoughReplicas or NotEnoughReplicasAfterAppend).<br>When used together, <code>min.insync.replicas</code> and <code>acks</code> allow you to enforce greater durability guarantees. A typical scenario would be to create a topic with a replication factor of 3, set <code>min.insync.replicas</code> to 2, and produce with <code>acks</code> of \"all\". This will ensure that the producer raises an exception if a majority of replicas do not receive a write.").define("compression.type", ConfigDef.Type.STRING, (Object)DEFAULT_COMPRESSION_TYPE, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])BrokerCompressionType.names().toArray(new String[0])), ConfigDef.Importance.MEDIUM, "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.").define("preallocate", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "True if we should preallocate the file on disk when creating a new log segment.").define(MESSAGE_FORMAT_VERSION_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_MESSAGE_FORMAT_VERSION, (ConfigDef.Validator)new MetadataVersionValidator(), ConfigDef.Importance.MEDIUM, MESSAGE_FORMAT_VERSION_DOC).define("message.timestamp.type", ConfigDef.Type.STRING, (Object)DEFAULT_MESSAGE_TIMESTAMP_TYPE, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{DEFAULT_MESSAGE_TIMESTAMP_TYPE, "LogAppendTime"}), ConfigDef.Importance.MEDIUM, "Define whether the timestamp in the message is message create time or log append time. The value should be either `CreateTime` or `LogAppendTime`").define(MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_CONFIG, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MESSAGE_TIMESTAMP_DIFFERENCE_MAX_MS_DOC).define("message.timestamp.before.max.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "This configuration sets the allowable timestamp difference between the broker's timestamp and the message timestamp. The message timestamp can be earlier than or equal to the broker's timestamp, with the maximum allowable difference determined by the value set in this configuration. If message.timestamp.type=CreateTime, the message will be rejected if the difference in timestamps exceeds this specified threshold. This configuration is ignored if message.timestamp.type=LogAppendTime.").define("message.timestamp.after.max.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "This configuration sets the allowable timestamp difference between the message timestamp and the broker's timestamp. The message timestamp can be later than or equal to the broker's timestamp, with the maximum allowable difference determined by the value set in this configuration. If message.timestamp.type=CreateTime, the message will be rejected if the difference in timestamps exceeds this specified threshold. This configuration is ignored if message.timestamp.type=LogAppendTime.").define(LEADER_REPLICATION_THROTTLED_REPLICAS_CONFIG, ConfigDef.Type.LIST, DEFAULT_LEADER_REPLICATION_THROTTLED_REPLICAS, ThrottledReplicaListValidator.INSTANCE, ConfigDef.Importance.MEDIUM, LEADER_REPLICATION_THROTTLED_REPLICAS_DOC).define(FOLLOWER_REPLICATION_THROTTLED_REPLICAS_CONFIG, ConfigDef.Type.LIST, DEFAULT_FOLLOWER_REPLICATION_THROTTLED_REPLICAS, ThrottledReplicaListValidator.INSTANCE, ConfigDef.Importance.MEDIUM, FOLLOWER_REPLICATION_THROTTLED_REPLICAS_DOC).define("message.downconversion.enable", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests. When set to <code>false</code>, broker will not perform down-conversion for consumers expecting an older message format. The broker responds with <code>UNSUPPORTED_VERSION</code> error for consume requests from such older clients. This configurationdoes not apply to any message format conversion that might be required for replication to followers.").define("remote.storage.enable", ConfigDef.Type.BOOLEAN, (Object)false, null, ConfigDef.Importance.MEDIUM, "To enable tiered storage for a topic, set this configuration as true. You can not disable this config once it is enabled. It will be provided in future versions.").define("local.retention.ms", ConfigDef.Type.LONG, (Object)-2L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-2), ConfigDef.Importance.MEDIUM, "The number of milli seconds to keep the local log segment before it gets deleted. Default value is -2, it represents `retention.ms` value is to be used. The effective value should always be less than or equal to `retention.ms` value.").define("local.retention.bytes", ConfigDef.Type.LONG, (Object)-2L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-2), ConfigDef.Importance.MEDIUM, "The maximum size of local log segments that can grow for a partition before it deletes the old segments. Default value is -2, it represents `retention.bytes` value to be used. The effective value should always be less than or equal to `retention.bytes` value.");
    }

    public static class LogConfigDef
    extends ConfigDef {
        public LogConfigDef() {
            this(new ConfigDef());
        }

        public LogConfigDef(ConfigDef base) {
            super(base);
        }

        public List<String> headers() {
            return Arrays.asList("Name", "Description", "Type", "Default", "Valid Values", LogConfig.SERVER_DEFAULT_HEADER_NAME, "Importance");
        }

        public String getConfigValue(ConfigDef.ConfigKey key, String headerName) {
            if (headerName.equals(LogConfig.SERVER_DEFAULT_HEADER_NAME)) {
                return (String)ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(key.name);
            }
            return super.getConfigValue(key, headerName);
        }

        public Optional<String> serverConfigName(String configName) {
            return Optional.ofNullable(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(configName));
        }
    }

    public static class RemoteLogConfig {
        public final boolean remoteStorageEnable;
        public final long localRetentionMs;
        public final long localRetentionBytes;

        private RemoteLogConfig(LogConfig config) {
            this.remoteStorageEnable = config.getBoolean("remote.storage.enable");
            this.localRetentionMs = config.getLong("local.retention.ms");
            this.localRetentionBytes = config.getLong("local.retention.bytes");
        }

        public String toString() {
            return "RemoteLogConfig{remoteStorageEnable=" + this.remoteStorageEnable + ", localRetentionMs=" + this.localRetentionMs + ", localRetentionBytes=" + this.localRetentionBytes + '}';
        }
    }

    public static class MessageFormatVersion {
        private final String messageFormatVersionString;
        private final String interBrokerProtocolVersionString;
        private final MetadataVersion messageFormatVersion;
        private final MetadataVersion interBrokerProtocolVersion;

        public MessageFormatVersion(String messageFormatVersionString, String interBrokerProtocolVersionString) {
            this.messageFormatVersionString = messageFormatVersionString;
            this.interBrokerProtocolVersionString = interBrokerProtocolVersionString;
            this.messageFormatVersion = MetadataVersion.fromVersionString((String)messageFormatVersionString);
            this.interBrokerProtocolVersion = MetadataVersion.fromVersionString((String)interBrokerProtocolVersionString);
        }

        public MetadataVersion messageFormatVersion() {
            return this.messageFormatVersion;
        }

        public MetadataVersion interBrokerProtocolVersion() {
            return this.interBrokerProtocolVersion;
        }

        public boolean shouldIgnore() {
            return LogConfig.shouldIgnoreMessageFormatVersion(this.interBrokerProtocolVersion);
        }

        public boolean shouldWarn() {
            return this.interBrokerProtocolVersion.isAtLeast(MetadataVersion.IBP_3_0_IV1) && this.messageFormatVersion.highestSupportedRecordVersion().precedes(RecordVersion.V2);
        }

        public String topicWarningMessage(String topicName) {
            return "Topic configuration message.format.version with value `" + this.messageFormatVersionString + "` is ignored for `" + topicName + "` because the inter-broker protocol version `" + this.interBrokerProtocolVersionString + "` is greater or equal than 3.0. This configuration is deprecated and it will be removed in Apache Kafka 4.0.";
        }
    }
}

