/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumFeatures {
    private static final VersionRange DISABLED = VersionRange.of(0, 0);
    private static final Logger log = LoggerFactory.getLogger(QuorumFeatures.class);
    private final int nodeId;
    private final ApiVersions apiVersions;
    private final Map<String, VersionRange> localSupportedFeatures;
    private final List<Integer> quorumNodeIds;

    QuorumFeatures(int nodeId, ApiVersions apiVersions, Map<String, VersionRange> localSupportedFeatures, List<Integer> quorumNodeIds) {
        this.nodeId = nodeId;
        this.apiVersions = apiVersions;
        this.localSupportedFeatures = Collections.unmodifiableMap(localSupportedFeatures);
        this.quorumNodeIds = Collections.unmodifiableList(quorumNodeIds);
    }

    public static QuorumFeatures create(int nodeId, ApiVersions apiVersions, Map<String, VersionRange> localSupportedFeatures, Collection<Node> quorumNodes) {
        List<Integer> nodeIds = quorumNodes.stream().map(Node::id).collect(Collectors.toList());
        return new QuorumFeatures(nodeId, apiVersions, localSupportedFeatures, nodeIds);
    }

    public static Map<String, VersionRange> defaultFeatureMap() {
        HashMap<String, VersionRange> features = new HashMap<String, VersionRange>(1);
        features.put("metadata.version", VersionRange.of(MetadataVersion.MINIMUM_KRAFT_VERSION.featureLevel(), MetadataVersion.latest().featureLevel()));
        return features;
    }

    public Optional<String> reasonNotSupported(String featureName, short level) {
        VersionRange localRange = this.localSupportedFeatures.getOrDefault(featureName, DISABLED);
        if (!localRange.contains(level)) {
            if (localRange.equals(DISABLED)) {
                return Optional.of("Local controller " + this.nodeId + " does not support this feature.");
            }
            return Optional.of("Local controller " + this.nodeId + " only supports versions " + localRange);
        }
        ArrayList<String> missing = new ArrayList<String>();
        for (int id : this.quorumNodeIds) {
            if (this.nodeId == id) continue;
            NodeApiVersions nodeVersions = this.apiVersions.get(Integer.toString(id));
            if (nodeVersions == null) {
                missing.add(Integer.toString(id));
                continue;
            }
            SupportedVersionRange supportedRange = (SupportedVersionRange)nodeVersions.supportedFeatures().get(featureName);
            VersionRange range = supportedRange == null ? DISABLED : VersionRange.of(supportedRange.min(), supportedRange.max());
            if (range.contains(level)) continue;
            if (range.equals(DISABLED)) {
                return Optional.of("Controller " + id + " does not support this feature.");
            }
            return Optional.of("Controller " + id + " only supports versions " + range);
        }
        if (!missing.isEmpty()) {
            log.info("Unable to get feature level information for controller(s): " + String.join((CharSequence)", ", missing));
        }
        return Optional.empty();
    }

    VersionRange localSupportedFeature(String featureName) {
        return this.localSupportedFeatures.getOrDefault(featureName, DISABLED);
    }

    boolean isControllerId(int nodeId) {
        return this.quorumNodeIds.contains(nodeId);
    }

    public Optional<String> reasonAllControllersZkMigrationNotReady() {
        boolean isReady;
        ArrayList<String> missingApiVers = new ArrayList<String>();
        ArrayList<String> zkMigrationNotReady = new ArrayList<String>();
        for (int id : this.quorumNodeIds) {
            if (this.nodeId == id) continue;
            NodeApiVersions nodeVersions = this.apiVersions.get(Integer.toString(id));
            if (nodeVersions == null) {
                missingApiVers.add(String.valueOf(id));
                continue;
            }
            if (nodeVersions.zkMigrationEnabled()) continue;
            zkMigrationNotReady.add(String.valueOf(id));
        }
        boolean bl = isReady = missingApiVers.isEmpty() && zkMigrationNotReady.isEmpty();
        if (!isReady) {
            String zkMigrationNotReadyMsg = zkMigrationNotReady.isEmpty() ? "" : "Nodes don't enable `zookeeper.metadata.migration.enable`: " + zkMigrationNotReady + ".";
            String missingApiVersionMsg = missingApiVers.isEmpty() ? "" : " Missing apiVersion from nodes: " + missingApiVers;
            return Optional.of(zkMigrationNotReadyMsg + missingApiVersionMsg);
        }
        return Optional.empty();
    }
}

