/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.client.methods;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.FileEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentDecoderChannel;
import org.apache.http.nio.FileContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZeroCopyConsumer<T>
extends AbstractAsyncResponseConsumer<T> {
    private final File file;
    private HttpResponse response;
    private FileChannel fileChannel;
    private long idx = -1L;

    public ZeroCopyConsumer(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File may nor be null");
        }
        this.file = file;
    }

    protected void onResponseReceived(HttpResponse response) {
        this.response = response;
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        long transferred;
        if (this.fileChannel == null) {
            FileOutputStream out = new FileOutputStream(this.file);
            this.fileChannel = out.getChannel();
            this.idx = 0L;
        }
        if ((transferred = decoder instanceof FileContentDecoder ? ((FileContentDecoder)decoder).transfer(this.fileChannel, this.idx, Integer.MAX_VALUE) : this.fileChannel.transferFrom((ReadableByteChannel)new ContentDecoderChannel(decoder), this.idx, Integer.MAX_VALUE)) > 0L) {
            this.idx += transferred;
        }
        if (decoder.isCompleted()) {
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }

    protected abstract T process(HttpResponse var1, File var2) throws Exception;

    protected T buildResult(HttpContext context) throws Exception {
        FileEntity entity = new FileEntity(this.file);
        entity.setContentType(this.response.getFirstHeader("Content-Type"));
        this.response.setEntity((HttpEntity)entity);
        return this.process(this.response, this.file);
    }

    protected void releaseResources() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileChannel = null;
        }
    }
}

