/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.conn;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.impl.nio.conn.LoggingIOSession;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.conn.OperatedAsyncClientConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionBufferStatus;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAsyncClientConnection
extends DefaultNHttpClientConnection
implements OperatedAsyncClientConnection {
    private final Log headerlog = LogFactory.getLog((String)"org.apache.http.headers");
    private final Log wirelog = LogFactory.getLog((String)"org.apache.http.wire");
    private final Log log;
    private String id;

    public DefaultAsyncClientConnection(String id, IOSession iosession, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(iosession, responseFactory, allocator, params);
        this.id = id;
        this.log = LogFactory.getLog(iosession.getClass());
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.session = new LoggingIOSession(iosession, this.id, this.log, this.wirelog);
        }
    }

    @Override
    public void upgrade(IOSession iosession) {
        this.session.setBufferStatus(null);
        if (this.log.isDebugEnabled() || this.wirelog.isDebugEnabled()) {
            this.log.debug((Object)(this.id + " Upgrade session " + iosession));
            this.session = new LoggingIOSession(iosession, this.id, this.headerlog, this.wirelog);
        } else {
            this.session = iosession;
        }
        this.session.setBufferStatus((SessionBufferStatus)this);
    }

    @Override
    public IOSession getIOSession() {
        return this.session;
    }

    protected NHttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new LoggingNHttpMessageWriter((NHttpMessageWriter<HttpRequest>)super.createRequestWriter(buffer, params));
    }

    protected NHttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new LoggingNHttpMessageParser((NHttpMessageParser<HttpResponse>)super.createResponseParser(buffer, responseFactory, params));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.id);
        buf.append(" [");
        switch (this.status) {
            case 0: {
                buf.append("ACTIVE");
                break;
            }
            case 1: {
                buf.append("CLOSING");
                break;
            }
            case 2: {
                buf.append("CLOSED");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingNHttpMessageParser
    implements NHttpMessageParser<HttpResponse> {
        private final NHttpMessageParser<HttpResponse> parser;

        public LoggingNHttpMessageParser(NHttpMessageParser<HttpResponse> parser) {
            this.parser = parser;
        }

        public void reset() {
            this.parser.reset();
        }

        public int fillBuffer(ReadableByteChannel channel) throws IOException {
            return this.parser.fillBuffer(channel);
        }

        public HttpResponse parse() throws IOException, HttpException {
            HttpResponse response = (HttpResponse)this.parser.parse();
            if (DefaultAsyncClientConnection.this.headerlog.isDebugEnabled() && response != null && DefaultAsyncClientConnection.this.headerlog.isDebugEnabled()) {
                DefaultAsyncClientConnection.this.headerlog.debug((Object)(DefaultAsyncClientConnection.this.id + " << " + response.getStatusLine().toString()));
                Header[] headers = response.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    DefaultAsyncClientConnection.this.headerlog.debug((Object)(DefaultAsyncClientConnection.this.id + " << " + headers[i].toString()));
                }
            }
            return response;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingNHttpMessageWriter
    implements NHttpMessageWriter<HttpRequest> {
        private final NHttpMessageWriter<HttpRequest> writer;

        public LoggingNHttpMessageWriter(NHttpMessageWriter<HttpRequest> writer) {
            this.writer = writer;
        }

        public void reset() {
            this.writer.reset();
        }

        public void write(HttpRequest request) throws IOException, HttpException {
            if (request != null && DefaultAsyncClientConnection.this.headerlog.isDebugEnabled()) {
                DefaultAsyncClientConnection.this.headerlog.debug((Object)(DefaultAsyncClientConnection.this.id + " >> " + request.getRequestLine().toString()));
                Header[] headers = request.getAllHeaders();
                for (int i = 0; i < headers.length; ++i) {
                    DefaultAsyncClientConnection.this.headerlog.debug((Object)(DefaultAsyncClientConnection.this.id + " >> " + headers[i].toString()));
                }
            }
            this.writer.write((HttpMessage)request);
        }
    }
}

