/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class BundleInfo {
    private Map m_exportedPackages = new HashMap();

    public void addExportedPackage(String packageName, Artifact artifact) {
        HashSet<Artifact> artifacts = (HashSet<Artifact>)this.getExportedPackages().get(packageName);
        if (artifacts == null) {
            artifacts = new HashSet<Artifact>();
            this.m_exportedPackages.put(packageName, artifacts);
        }
        artifacts.add(artifact);
    }

    protected Map getExportedPackages() {
        return this.m_exportedPackages;
    }

    public Map getDuplicatedExports() {
        HashMap<String, Set> duplicatedExports = new HashMap<String, Set>();
        for (Map.Entry entry : this.getExportedPackages().entrySet()) {
            Set artifacts = (Set)entry.getValue();
            if (artifacts.size() <= 1) continue;
            HashSet<String> artifactKeys = new HashSet<String>();
            String packageName = (String)entry.getKey();
            for (Artifact artifact : artifacts) {
                artifactKeys.add(artifact.getGroupId() + "." + artifact.getArtifactId());
            }
            if (artifactKeys.size() <= 1) continue;
            duplicatedExports.put(packageName, artifacts);
        }
        return duplicatedExports;
    }

    public void merge(BundleInfo bundleInfo) {
        for (Map.Entry entry : bundleInfo.getExportedPackages().entrySet()) {
            String packageName = (String)entry.getKey();
            Collection artifacts = (Collection)entry.getValue();
            HashSet artifactsWithPackage = (HashSet)this.getExportedPackages().get(packageName);
            if (artifactsWithPackage == null) {
                artifactsWithPackage = new HashSet();
                this.getExportedPackages().put(packageName, artifactsWithPackage);
            }
            artifactsWithPackage.addAll(artifacts);
        }
    }
}

