/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeadersImpl
implements HttpHeaders {
    private MultivaluedMap<String, String> headers;

    public HttpHeadersImpl(Message message) {
        this.headers = new MetadataMap<String, String>((Map)message.get((Object)Message.PROTOCOL_HEADERS), true, true);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List lValues = (List)this.headers.get((Object)"Accept");
        if (lValues == null || lValues.isEmpty()) {
            return Collections.emptyList();
        }
        List<MediaType> mediaTypes = JAXRSUtils.parseMediaTypes((String)lValues.get(0));
        this.sortMediaTypesUsingQualityFactor(mediaTypes);
        return mediaTypes;
    }

    public Map<String, Cookie> getCookies() {
        List<String> cs = this.getListValues("Cookie");
        HashMap<String, Cookie> cl = new HashMap<String, Cookie>();
        for (String c : cs) {
            Cookie cookie = Cookie.valueOf((String)c);
            cl.put(cookie.getName(), cookie);
        }
        return cl;
    }

    public Locale getLanguage() {
        List<String> values = this.getListValues("Content-Language");
        return values.size() == 0 ? null : this.createLocale(values.get(0).trim());
    }

    public MediaType getMediaType() {
        List<String> values = this.getListValues("Content-Type");
        return values.size() == 0 ? null : MediaType.valueOf((String)values.get(0));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        LinkedHashMap newHeaders = new LinkedHashMap();
        for (Map.Entry entry : this.headers.entrySet()) {
            newHeaders.put(entry.getKey(), this.getListValues((String)entry.getKey()));
        }
        return new MetadataMap<String, String>(newHeaders, true, true);
    }

    public List<Locale> getAcceptableLanguages() {
        List<String> ls = this.getListValues("Accept-Language");
        ArrayList<Locale> newLs = new ArrayList<Locale>();
        HashMap<Locale, Float> prefs = new HashMap<Locale, Float>();
        for (String l : ls) {
            String[] pair = l.split(";");
            Locale locale = this.createLocale(pair[0].trim());
            newLs.add(locale);
            if (pair.length > 1) {
                String[] pair2 = pair[1].split("=");
                if (pair2.length > 1) {
                    prefs.put(locale, Float.valueOf(JAXRSUtils.getMediaTypeQualityFactor(pair2[1].trim())));
                    continue;
                }
                prefs.put(locale, Float.valueOf(1.0f));
                continue;
            }
            prefs.put(locale, Float.valueOf(1.0f));
        }
        if (newLs.size() <= 1) {
            return newLs;
        }
        Collections.sort(newLs, new AcceptLanguageComparator(prefs));
        return newLs;
    }

    public List<String> getRequestHeader(String name) {
        return this.getListValues(name);
    }

    private List<String> getListValues(String headerName) {
        List values = (List)this.headers.get((Object)headerName);
        if (values == null || values.isEmpty() || values.get(0) == null) {
            return Collections.emptyList();
        }
        if (HttpUtils.isDateRelatedHeader(headerName)) {
            return values;
        }
        String[] ls = ((String)values.get(0)).split(",");
        if (ls.length == 1) {
            return Collections.singletonList(ls[0].trim());
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String v : ls) {
            newValues.add(v.trim());
        }
        return newValues;
    }

    private Locale createLocale(String value) {
        String[] values = value.split("-");
        if (values.length == 0 || values.length > 2) {
            throw new IllegalArgumentException("Illegal locale value : " + value);
        }
        if (values.length == 1) {
            return new Locale(values[0]);
        }
        return new Locale(values[0], values[1]);
    }

    private void sortMediaTypesUsingQualityFactor(List<MediaType> types) {
        if (types.size() > 1) {
            Collections.sort(types, new Comparator<MediaType>(){

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    return JAXRSUtils.compareMediaTypesQualityFactors(mt1, mt2);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptLanguageComparator
    implements Comparator<Locale> {
        private Map<Locale, Float> prefs;

        public AcceptLanguageComparator(Map<Locale, Float> prefs) {
            this.prefs = prefs;
        }

        @Override
        public int compare(Locale lang1, Locale lang2) {
            float p1 = this.prefs.get(lang1).floatValue();
            float p2 = this.prefs.get(lang2).floatValue();
            return Float.compare(p1, p2) * -1;
        }
    }
}

