/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import org.apache.camel.support.task.budget.IterationBudget;

public class IterationBoundedBudget
implements IterationBudget {
    public static final int UNLIMITED_ITERATIONS = -1;
    private final long initialDelay;
    private final long interval;
    private final int maxIterations;
    private int iterations;

    IterationBoundedBudget(long initialDelay, long interval, int maxIterations) {
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.maxIterations = maxIterations;
    }

    @Override
    public long initialDelay() {
        return this.initialDelay;
    }

    @Override
    public long interval() {
        return this.interval;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int iterations() {
        return this.iterations;
    }

    @Override
    public boolean next() {
        if (this.canContinue()) {
            if (this.iterations != -1) {
                ++this.iterations;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinue() {
        if (this.maxIterations != -1) {
            return this.iterations < this.maxIterations;
        }
        return true;
    }
}

