/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import org.apache.camel.support.task.budget.IterationBoundedBudgetBuilder;
import org.apache.camel.support.task.budget.IterationTimeBoundedBudgetBuilder;
import org.apache.camel.support.task.budget.TimeBoundedBudget;

public final class Budgets {
    private static final long DEFAULT_INITIAL_DELAY = 0L;
    private static final long DEFAULT_INTERVAL = 1000L;

    private Budgets() {
    }

    public static TimeBoundedBudgetBuilder timeBudget() {
        return new TimeBoundedBudgetBuilder();
    }

    public static IterationBoundedBudgetBuilder iterationBudget() {
        return new IterationBoundedBudgetBuilder();
    }

    public static IterationTimeBoundedBudgetBuilder iterationTimeBudget() {
        return new IterationTimeBoundedBudgetBuilder();
    }

    public static int atLeastOnce(int iterations) {
        if (iterations <= 0) {
            return 1;
        }
        return iterations;
    }

    public static class TimeBoundedBudgetBuilder {
        private static final long DEFAULT_MAX_DURATION = 5000L;
        private long initialDelay = 0L;
        private long interval = 1000L;
        private long maxDuration = 5000L;

        public TimeBoundedBudgetBuilder withInitialDelay(Duration duration) {
            this.initialDelay = duration.toMillis();
            return this;
        }

        public TimeBoundedBudgetBuilder withInterval(Duration duration) {
            this.interval = duration.toMillis();
            return this;
        }

        public TimeBoundedBudgetBuilder withMaxDuration(Duration duration) {
            this.maxDuration = duration.toMillis();
            return this;
        }

        public TimeBoundedBudget build() {
            return new TimeBoundedBudget(this.initialDelay, this.interval, this.maxDuration);
        }
    }
}

