/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.CamelContextTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelContextTrackerRegistry {
    public static final CamelContextTrackerRegistry INSTANCE = new CamelContextTrackerRegistry();
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextTrackerRegistry.class);
    private final Set<CamelContextTracker> trackers = new LinkedHashSet<CamelContextTracker>();

    private CamelContextTrackerRegistry() {
    }

    public synchronized void addTracker(CamelContextTracker tracker) {
        this.trackers.add(tracker);
    }

    public synchronized void removeTracker(CamelContextTracker tracker) {
        this.trackers.remove(tracker);
    }

    synchronized void contextCreated(CamelContext camelContext) {
        for (CamelContextTracker tracker : this.trackers) {
            try {
                if (!tracker.accept(camelContext)) continue;
                tracker.contextCreated(camelContext);
            }
            catch (Exception e) {
                LOG.warn("Error calling CamelContext tracker. This exception is ignored.", e);
            }
        }
    }
}

