/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.pool;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtThreadGroup;
import org.fusesource.hawtdispatch.internal.NioManager;
import org.fusesource.hawtdispatch.internal.WorkerPool;
import org.fusesource.hawtdispatch.internal.WorkerThread;
import org.fusesource.hawtdispatch.internal.pool.SimpleThread;

public class SimplePool
implements WorkerPool {
    final ConcurrentLinkedQueue<Task> tasks = new ConcurrentLinkedQueue();
    final GlobalDispatchQueue globalQueue;
    final String name;
    final int priority;
    final SimpleThread[] threads;
    volatile boolean shutdown = false;
    final ThreadGroup group;
    public static final boolean DEBUG = false;

    public SimplePool(GlobalDispatchQueue globalQueue, int parallelism, DispatchPriority priority) {
        this.globalQueue = globalQueue;
        this.name = globalQueue.dispatcher.getLabel() + "-" + (Object)((Object)priority);
        this.group = new HawtThreadGroup(globalQueue.dispatcher, this.name);
        this.priority = SimplePool.priority(priority);
        this.threads = new SimpleThread[parallelism];
    }

    private static int priority(DispatchPriority priority) {
        switch (priority) {
            case HIGH: {
                return 10;
            }
            case DEFAULT: {
                return 5;
            }
            case LOW: {
                return 1;
            }
        }
        return 0;
    }

    public void start() {
        this.shutdown = false;
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = this.createWorker(i);
            this.threads[i].start();
        }
    }

    private SimpleThread createWorker(int index) {
        SimpleThread w;
        try {
            w = new SimpleThread(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        w.setDaemon(true);
        w.setPriority(this.priority);
        w.setName(this.name + "-" + (index + 1));
        return w;
    }

    public WorkerThread[] getThreads() {
        return this.threads;
    }

    public void shutdown() {
        try {
            int i;
            while (!this.tasks.isEmpty()) {
                Thread.sleep(50L);
            }
            this.shutdown = true;
            for (i = 0; i < this.threads.length; ++i) {
                this.threads[i].unpark();
            }
            for (i = 0; i < this.threads.length; ++i) {
                this.threads[i].join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void execute(Task runnable) {
        NioManager nio;
        WorkerThread current = WorkerThread.currentWorkerThread();
        this.tasks.add(runnable);
        for (int i = 0; !(i >= this.threads.length || this.threads[i] != current && (nio = this.threads[i].getNioManager()).wakeupIfSelecting()); ++i) {
        }
    }

    public void park(SimpleThread thread) {
        try {
            this.debug("parking thread: %s", thread.getName());
            thread.getNioManager().select(-1L);
            this.debug("unparking thread: %s", thread.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void debug(String str, Object ... args) {
    }

    protected void debug(Throwable thrown, String str, Object ... args) {
    }
}

