/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatcherChain
implements Watcher {
    private final Collection<Watcher> _watchers;

    public WatcherChain(Watcher ... watchers) {
        this(Arrays.asList(watchers));
    }

    public WatcherChain(Collection<Watcher> watchers) {
        this._watchers = watchers;
    }

    public void process(WatchedEvent event) {
        for (Watcher watcher : this._watchers) {
            watcher.process(event);
        }
    }

    public static Watcher createChain(Watcher ... watchers) {
        if (watchers == null || watchers.length == 0) {
            return null;
        }
        ArrayList<Watcher> list = new ArrayList<Watcher>();
        for (Watcher watcher : watchers) {
            if (watcher == null) continue;
            list.add(watcher);
        }
        if (list.size() == 1) {
            return (Watcher)list.get(0);
        }
        return new WatcherChain(list);
    }
}

