/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.LoggingLevel;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CamelLogger {
    private Logger log;
    private LoggingLevel level;
    private Marker marker;

    public CamelLogger() {
        this(LoggerFactory.getLogger(CamelLogger.class));
    }

    public CamelLogger(Logger log2) {
        this(log2, LoggingLevel.INFO);
    }

    public CamelLogger(Logger log2, LoggingLevel level) {
        this(log2, level, null);
    }

    public CamelLogger(Logger log2, LoggingLevel level, String marker) {
        this.log = log2;
        this.setLevel(level);
        this.setMarker(marker);
    }

    public CamelLogger(String logName) {
        this(LoggerFactory.getLogger(logName));
    }

    public CamelLogger(String logName, LoggingLevel level) {
        this(logName, level, null);
    }

    public CamelLogger(String logName, LoggingLevel level, String marker) {
        this(LoggerFactory.getLogger(logName), level, marker);
    }

    public String toString() {
        return "Logger[" + this.log + "]";
    }

    public void log(String message, LoggingLevel loggingLevel) {
        LoggingLevel oldLogLevel = this.getLevel();
        this.setLevel(loggingLevel);
        this.log(message);
        this.setLevel(oldLogLevel);
    }

    public void log(String message) {
        if (CamelLogger.shouldLog(this.log, this.level)) {
            CamelLogger.log(this.log, this.level, this.marker, message);
        }
    }

    public void doLog(String message) {
        CamelLogger.log(this.log, this.level, this.marker, message);
    }

    public void log(String message, Throwable exception, LoggingLevel loggingLevel) {
        CamelLogger.log(this.log, loggingLevel, this.marker, message, exception);
    }

    public void log(String message, Throwable exception) {
        if (CamelLogger.shouldLog(this.log, this.level)) {
            CamelLogger.log(this.log, this.level, this.marker, message, exception);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log2) {
        this.log = log2;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Log level may not be null");
        }
        this.level = level;
    }

    public void setLogName(String logName) {
        this.log = LoggerFactory.getLogger(logName);
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public void setMarker(String marker) {
        this.marker = ObjectHelper.isNotEmpty(marker) ? MarkerFactory.getMarker(marker) : null;
    }

    public static void log(Logger log2, LoggingLevel level, String message) {
        switch (level) {
            case DEBUG: {
                log2.debug(message);
                break;
            }
            case ERROR: {
                log2.error(message);
                break;
            }
            case INFO: {
                log2.info(message);
                break;
            }
            case TRACE: {
                log2.trace(message);
                break;
            }
            case WARN: {
                log2.warn(message);
                break;
            }
        }
    }

    public static void log(Logger log2, LoggingLevel level, Marker marker, String message) {
        if (marker == null) {
            CamelLogger.log(log2, level, message);
            return;
        }
        switch (level) {
            case DEBUG: {
                log2.debug(marker, message);
                break;
            }
            case ERROR: {
                log2.error(marker, message);
                break;
            }
            case INFO: {
                log2.info(marker, message);
                break;
            }
            case TRACE: {
                log2.trace(marker, message);
                break;
            }
            case WARN: {
                log2.warn(marker, message);
                break;
            }
        }
    }

    public static void log(Logger log2, LoggingLevel level, String message, Throwable th) {
        switch (level) {
            case DEBUG: {
                log2.debug(message, th);
                break;
            }
            case ERROR: {
                log2.error(message, th);
                break;
            }
            case INFO: {
                log2.info(message, th);
                break;
            }
            case TRACE: {
                log2.trace(message, th);
                break;
            }
            case WARN: {
                log2.warn(message, th);
                break;
            }
        }
    }

    public static void log(Logger log2, LoggingLevel level, Marker marker, String message, Throwable th) {
        if (marker == null) {
            CamelLogger.log(log2, level, message, th);
            return;
        }
        switch (level) {
            case DEBUG: {
                log2.debug(marker, message, th);
                break;
            }
            case ERROR: {
                log2.error(marker, message, th);
                break;
            }
            case INFO: {
                log2.info(marker, message, th);
                break;
            }
            case TRACE: {
                log2.trace(marker, message, th);
                break;
            }
            case WARN: {
                log2.warn(marker, message, th);
                break;
            }
        }
    }

    public boolean shouldLog() {
        return CamelLogger.shouldLog(this.log, this.level);
    }

    public static boolean shouldLog(Logger log2, LoggingLevel level) {
        switch (level) {
            case DEBUG: {
                return log2.isDebugEnabled();
            }
            case ERROR: {
                return log2.isErrorEnabled();
            }
            case INFO: {
                return log2.isInfoEnabled();
            }
            case TRACE: {
                return log2.isTraceEnabled();
            }
            case WARN: {
                return log2.isWarnEnabled();
            }
        }
        return false;
    }
}

