/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.protocol;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.amqp.AmqpProtocolConverter;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.ResponseHandler;
import org.apache.activemq.transport.amqp.message.AutoOutboundTransformer;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.OutboundTransformer;
import org.apache.activemq.transport.amqp.protocol.AmqpAbstractLink;
import org.apache.activemq.transport.amqp.protocol.AmqpSession;
import org.apache.activemq.transport.amqp.protocol.AmqpTransferTagGenerator;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.fusesource.hawtbuf.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSender
extends AmqpAbstractLink<Sender> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpSender.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final OutboundTransformer outboundTransformer = new AutoOutboundTransformer();
    private final AmqpTransferTagGenerator tagCache = new AmqpTransferTagGenerator();
    private final LinkedList<MessageDispatch> outbound = new LinkedList();
    private final LinkedList<Delivery> dispatchedInTx = new LinkedList();
    private final ConsumerInfo consumerInfo;
    private AbstractSubscription subscription;
    private AtomicInteger prefetchExtension;
    private int currentCreditRequest;
    private int logicalDeliveryCount;
    private final boolean presettle;
    private boolean draining;
    private long lastDeliveredSequenceId;
    private Buffer currentBuffer;
    private Delivery currentDelivery;

    public AmqpSender(AmqpSession session, Sender endpoint, ConsumerInfo consumerInfo) {
        super(session, endpoint);
        ((Sender)this.endpoint).setReceiverSettleMode(ReceiverSettleMode.FIRST);
        ((Sender)this.endpoint).setSenderSettleMode(endpoint.getRemoteSenderSettleMode());
        this.consumerInfo = consumerInfo;
        this.presettle = ((Sender)this.getEndpoint()).getSenderSettleMode() == SenderSettleMode.SETTLED;
    }

    @Override
    public void open() {
        if (!this.isClosed()) {
            this.session.registerSender(this.getConsumerId(), this);
            this.subscription = (AbstractSubscription)this.session.getConnection().lookupPrefetchSubscription(this.consumerInfo);
            this.prefetchExtension = this.subscription.getPrefetchExtension();
        }
        super.open();
    }

    @Override
    public void detach() {
        if (!this.isClosed() && this.isOpened()) {
            RemoveInfo removeCommand = new RemoveInfo((DataStructure)this.getConsumerId());
            removeCommand.setLastDeliveredSequenceId(this.lastDeliveredSequenceId);
            this.sendToActiveMQ((Command)removeCommand, new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    AmqpSender.this.session.unregisterSender(AmqpSender.this.getConsumerId());
                    AmqpSender.super.detach();
                }
            });
        } else {
            super.detach();
        }
    }

    @Override
    public void close() {
        if (!this.isClosed() && this.isOpened()) {
            RemoveInfo removeCommand = new RemoveInfo((DataStructure)this.getConsumerId());
            removeCommand.setLastDeliveredSequenceId(this.lastDeliveredSequenceId);
            this.sendToActiveMQ((Command)removeCommand, new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    if (AmqpSender.this.consumerInfo.isDurable()) {
                        RemoveSubscriptionInfo rsi = new RemoveSubscriptionInfo();
                        rsi.setConnectionId(AmqpSender.this.session.getConnection().getConnectionId());
                        rsi.setSubscriptionName(((Sender)AmqpSender.this.getEndpoint()).getName());
                        rsi.setClientId(AmqpSender.this.session.getConnection().getClientId());
                        AmqpSender.this.sendToActiveMQ((Command)rsi);
                    }
                    AmqpSender.this.session.unregisterSender(AmqpSender.this.getConsumerId());
                    AmqpSender.super.close();
                }
            });
        } else {
            super.close();
        }
    }

    @Override
    public void flow() throws Exception {
        Object endpoint = this.getEndpoint();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Flow: draining={}, drain={} credit={}, currentCredit={}, senderDeliveryCount={} - Sub={}", new Object[]{this.draining, endpoint.getDrain(), endpoint.getCredit(), this.currentCreditRequest, this.logicalDeliveryCount, this.subscription});
        }
        int endpointCredit = endpoint.getCredit();
        if (endpoint.getDrain() && !this.draining) {
            if (endpointCredit > 0) {
                this.draining = true;
                MessagePull pullRequest = new MessagePull();
                pullRequest.setConsumerId(this.getConsumerId());
                pullRequest.setDestination(this.getDestination());
                pullRequest.setTimeout(-1L);
                pullRequest.setAlwaysSignalDone(true);
                pullRequest.setQuantity(endpointCredit);
                LOG.trace("Pull case -> consumer pull request quantity = {}", (Object)endpointCredit);
                this.sendToActiveMQ((Command)pullRequest);
            } else {
                LOG.trace("Pull case -> sending any Queued messages and marking drained");
                this.pumpOutbound();
                ((Sender)this.getEndpoint()).drained();
                this.session.pumpProtonToSocket();
                this.currentCreditRequest = 0;
                this.logicalDeliveryCount = 0;
            }
        } else if (endpointCredit >= 0) {
            if (endpointCredit == 0 && this.currentCreditRequest != 0) {
                this.prefetchExtension.set(0);
                this.currentCreditRequest = 0;
                this.logicalDeliveryCount = 0;
                LOG.trace("Flow: credit 0 for sub:" + this.subscription);
            } else {
                int deltaToAdd = endpointCredit;
                int logicalCredit = this.currentCreditRequest - this.logicalDeliveryCount;
                if (logicalCredit > 0) {
                    deltaToAdd -= logicalCredit;
                } else {
                    this.logicalDeliveryCount = 0;
                }
                if (deltaToAdd > 0) {
                    this.currentCreditRequest = this.prefetchExtension.addAndGet(deltaToAdd);
                    this.subscription.wakeupDestinationsForDispatch();
                    this.subscription.setPrefetchSize(0);
                    LOG.trace("Flow: credit addition of {} for sub {}", (Object)deltaToAdd, (Object)this.subscription);
                }
            }
        }
    }

    @Override
    public void delivery(Delivery delivery) throws Exception {
        MessageDispatch md = (MessageDispatch)delivery.getContext();
        DeliveryState state = delivery.getRemoteState();
        if (state instanceof TransactionalState) {
            Outcome outcome;
            TransactionalState txState = (TransactionalState)state;
            LOG.trace("onDelivery: TX delivery state = {}", (Object)state);
            if (txState.getOutcome() != null && (outcome = txState.getOutcome()) instanceof Accepted) {
                LocalTransactionId txId = new LocalTransactionId(this.session.getConnection().getConnectionId(), AmqpSupport.toLong(txState.getTxnId()));
                this.session.enlist((TransactionId)txId);
                this.dispatchedInTx.addFirst(delivery);
                if (!delivery.remotelySettled()) {
                    TransactionalState txAccepted = new TransactionalState();
                    txAccepted.setOutcome((Outcome)Accepted.getInstance());
                    txAccepted.setTxnId(txState.getTxnId());
                    delivery.disposition((DeliveryState)txAccepted);
                }
            }
        } else if (state instanceof Accepted) {
            LOG.trace("onDelivery: accepted state = {}", (Object)state);
            if (!delivery.remotelySettled()) {
                delivery.disposition((DeliveryState)new Accepted());
            }
            this.settle(delivery, 4);
        } else if (state instanceof Rejected) {
            LOG.trace("onDelivery: Rejected state = {}, message poisoned.", (Object)state, (Object)md.getRedeliveryCounter());
            this.settle(delivery, 1);
        } else if (state instanceof Released) {
            LOG.trace("onDelivery: Released state = {}", (Object)state);
            this.settle(delivery, -1);
        } else if (state instanceof Modified) {
            Modified modified = (Modified)state;
            if (Boolean.TRUE.equals(modified.getDeliveryFailed())) {
                md.setRedeliveryCounter(md.getRedeliveryCounter() + 1);
            }
            LOG.trace("onDelivery: Modified state = {}, delivery count now {}", (Object)state, (Object)md.getRedeliveryCounter());
            int ackType = -1;
            Boolean undeliverableHere = modified.getUndeliverableHere();
            if (undeliverableHere != null && undeliverableHere.booleanValue()) {
                ackType = 1;
            }
            this.settle(delivery, ackType);
        }
        this.pumpOutbound();
    }

    @Override
    public void commit(LocalTransactionId txnId) throws Exception {
        if (!this.dispatchedInTx.isEmpty()) {
            for (final Delivery delivery : this.dispatchedInTx) {
                MessageDispatch dispatch = (MessageDispatch)delivery.getContext();
                MessageAck pendingTxAck = new MessageAck(dispatch, 4, 1);
                pendingTxAck.setFirstMessageId(dispatch.getMessage().getMessageId());
                pendingTxAck.setTransactionId((TransactionId)txnId);
                LOG.trace("Sending commit Ack to ActiveMQ: {}", (Object)pendingTxAck);
                this.sendToActiveMQ((Command)pendingTxAck, new ResponseHandler(){

                    @Override
                    public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            exception.printStackTrace();
                            ((Sender)AmqpSender.this.getEndpoint()).close();
                        } else {
                            delivery.settle();
                        }
                        AmqpSender.this.session.pumpProtonToSocket();
                    }
                });
            }
            this.dispatchedInTx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(LocalTransactionId txnId) throws Exception {
        LinkedList<MessageDispatch> linkedList = this.outbound;
        synchronized (linkedList) {
            LOG.trace("Rolling back {} messages for redelivery. ", (Object)this.dispatchedInTx.size());
            for (Delivery delivery : this.dispatchedInTx) {
                MessageDispatch dispatch = (MessageDispatch)delivery.getContext();
                dispatch.getMessage().setTransactionId(null);
                if (!delivery.remotelySettled()) continue;
                dispatch.setRedeliveryCounter(dispatch.getRedeliveryCounter() + 1);
                this.outbound.addFirst(dispatch);
            }
            this.dispatchedInTx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageDispatch(MessageDispatch dispatch) throws Exception {
        if (!this.isClosed()) {
            LinkedList<MessageDispatch> linkedList = this.outbound;
            synchronized (linkedList) {
                this.outbound.addLast(dispatch);
            }
            this.pumpOutbound();
            this.session.pumpProtonToSocket();
        }
    }

    public void onConsumerControl(ConsumerControl control) {
        if (control.isClose()) {
            this.close(new ErrorCondition(AmqpError.INTERNAL_ERROR, "Receiver forcably closed"));
            this.session.pumpProtonToSocket();
        }
    }

    public String toString() {
        return "AmqpSender {" + this.getConsumerId() + "}";
    }

    public ConsumerId getConsumerId() {
        return this.consumerInfo.getConsumerId();
    }

    @Override
    public ActiveMQDestination getDestination() {
        return this.consumerInfo.getDestination();
    }

    @Override
    public void setDestination(ActiveMQDestination destination) {
        this.consumerInfo.setDestination(destination);
    }

    public void pumpOutbound() throws Exception {
        while (!this.isClosed()) {
            while (this.currentBuffer != null) {
                int sent = ((Sender)this.getEndpoint()).send(this.currentBuffer.data, this.currentBuffer.offset, this.currentBuffer.length);
                if (sent > 0) {
                    this.currentBuffer.moveHead(sent);
                    if (this.currentBuffer.length != 0) continue;
                    if (this.presettle) {
                        this.settle(this.currentDelivery, 4);
                    } else {
                        ((Sender)this.getEndpoint()).advance();
                    }
                    this.currentBuffer = null;
                    this.currentDelivery = null;
                    ++this.logicalDeliveryCount;
                    continue;
                }
                return;
            }
            if (this.outbound.isEmpty()) {
                return;
            }
            MessageDispatch md = this.outbound.removeFirst();
            try {
                ActiveMQMessage jms;
                ActiveMQMessage temp = null;
                if (md.getMessage() != null) {
                    temp = (ActiveMQMessage)md.getMessage().copy();
                }
                if ((jms = temp) == null) {
                    LOG.trace("Sender:[{}] browse done.", (Object)((Sender)this.getEndpoint()).getName());
                    ((Sender)this.getEndpoint()).drained();
                    this.draining = false;
                    this.currentCreditRequest = 0;
                    this.logicalDeliveryCount = 0;
                    continue;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sender:[{}] msgId={} draining={}, drain={}, credit={}, remoteCredit={}, queued={}", new Object[]{((Sender)this.getEndpoint()).getName(), jms.getJMSMessageID(), this.draining, ((Sender)this.getEndpoint()).getDrain(), ((Sender)this.getEndpoint()).getCredit(), ((Sender)this.getEndpoint()).getRemoteCredit(), ((Sender)this.getEndpoint()).getQueued()});
                }
                if (this.draining && ((Sender)this.getEndpoint()).getCredit() == 0) {
                    LOG.trace("Sender:[{}] browse complete.", (Object)((Sender)this.getEndpoint()).getName());
                    ((Sender)this.getEndpoint()).drained();
                    this.draining = false;
                    this.currentCreditRequest = 0;
                    this.logicalDeliveryCount = 0;
                }
                jms.setRedeliveryCounter(md.getRedeliveryCounter());
                jms.setReadOnlyBody(true);
                EncodedMessage amqp = this.outboundTransformer.transform(jms);
                if (amqp == null || amqp.getLength() <= 0) continue;
                this.currentBuffer = new Buffer(amqp.getArray(), amqp.getArrayOffset(), amqp.getLength());
                if (this.presettle) {
                    this.currentDelivery = ((Sender)this.getEndpoint()).delivery(EMPTY_BYTE_ARRAY, 0, 0);
                } else {
                    byte[] tag = this.tagCache.getNextTag();
                    this.currentDelivery = ((Sender)this.getEndpoint()).delivery(tag, 0, tag.length);
                }
                this.currentDelivery.setContext((Object)md);
                this.currentDelivery.setMessageFormat((int)amqp.getMessageFormat());
            }
            catch (Exception e) {
                LOG.warn("Error detected while flushing outbound messages: {}", (Object)e.getMessage());
            }
        }
    }

    private void settle(final Delivery delivery, int ackType) throws Exception {
        byte[] tag = delivery.getTag();
        if (tag != null && tag.length > 0 && delivery.remotelySettled()) {
            this.tagCache.returnTag(tag);
        }
        if (ackType == -1) {
            delivery.settle();
            this.onMessageDispatch((MessageDispatch)delivery.getContext());
        } else {
            MessageDispatch md = (MessageDispatch)delivery.getContext();
            this.lastDeliveredSequenceId = md.getMessage().getMessageId().getBrokerSequenceId();
            MessageAck ack = new MessageAck();
            ack.setConsumerId(this.getConsumerId());
            ack.setFirstMessageId(md.getMessage().getMessageId());
            ack.setLastMessageId(md.getMessage().getMessageId());
            ack.setMessageCount(1);
            ack.setAckType((byte)ackType);
            ack.setDestination(md.getDestination());
            LOG.trace("Sending Ack to ActiveMQ: {}", (Object)ack);
            this.sendToActiveMQ((Command)ack, new ResponseHandler(){

                @Override
                public void onResponse(AmqpProtocolConverter converter, Response response) throws IOException {
                    if (response.isException()) {
                        if (response.isException()) {
                            Throwable exception = ((ExceptionResponse)response).getException();
                            exception.printStackTrace();
                            ((Sender)AmqpSender.this.getEndpoint()).close();
                        }
                    } else {
                        delivery.settle();
                    }
                    AmqpSender.this.session.pumpProtonToSocket();
                }
            });
        }
    }
}

