/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.ZipException;
import org.eclipse.jetty.spdy.CompressionDictionary;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.SessionException;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.SessionStatus;
import org.eclipse.jetty.spdy.api.StreamStatus;

public abstract class HeadersBlockParser {
    private final CompressionFactory.Decompressor decompressor;
    private byte[] data;
    private boolean needsDictionary = true;

    protected HeadersBlockParser(CompressionFactory.Decompressor decompressor) {
        this.decompressor = decompressor;
    }

    public boolean parse(int streamId, short version, int length, ByteBuffer buffer) {
        boolean accumulated = this.accumulate(length, buffer);
        if (!accumulated) {
            return false;
        }
        byte[] compressedHeaders = this.data;
        this.data = null;
        ByteBuffer decompressedHeaders = this.decompress(version, compressedHeaders);
        Charset iso1 = StandardCharsets.ISO_8859_1;
        int count = this.readCount(version, decompressedHeaders);
        for (int i = 0; i < count; ++i) {
            String[] values;
            int nameLength = this.readNameLength(version, decompressedHeaders);
            if (nameLength == 0) {
                throw new StreamException(streamId, StreamStatus.PROTOCOL_ERROR, "Invalid header name length");
            }
            byte[] nameBytes = new byte[nameLength];
            decompressedHeaders.get(nameBytes);
            String name = new String(nameBytes, iso1);
            int valueLength = this.readValueLength(version, decompressedHeaders);
            if (valueLength == 0) {
                throw new StreamException(streamId, StreamStatus.PROTOCOL_ERROR, "Invalid header value length");
            }
            byte[] valueBytes = new byte[valueLength];
            decompressedHeaders.get(valueBytes);
            String value = new String(valueBytes, iso1);
            for (String v : values = value.split("\u0000")) {
                if (v.length() != 0) continue;
                throw new StreamException(streamId, StreamStatus.PROTOCOL_ERROR, "Invalid multi valued header");
            }
            this.onHeader(name, values);
        }
        return true;
    }

    private boolean accumulate(int length, ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (this.data == null) {
            if (remaining < length) {
                this.data = new byte[remaining];
                buffer.get(this.data);
                return false;
            }
            this.data = new byte[length];
            buffer.get(this.data);
            return true;
        }
        int accumulated = this.data.length;
        int needed = length - accumulated;
        if (remaining < needed) {
            byte[] local = Arrays.copyOf(this.data, accumulated + remaining);
            buffer.get(local, accumulated, remaining);
            this.data = local;
            return false;
        }
        byte[] local = Arrays.copyOf(this.data, length);
        buffer.get(local, accumulated, needed);
        this.data = local;
        return true;
    }

    private int readCount(int version, ByteBuffer buffer) {
        switch (version) {
            case 2: {
                return buffer.getShort();
            }
            case 3: {
                return buffer.getInt();
            }
        }
        throw new IllegalStateException();
    }

    private int readNameLength(int version, ByteBuffer buffer) {
        return this.readCount(version, buffer);
    }

    private int readValueLength(int version, ByteBuffer buffer) {
        return this.readCount(version, buffer);
    }

    protected abstract void onHeader(String var1, String[] var2);

    private ByteBuffer decompress(short version, byte[] compressed) {
        try {
            byte[] decompressed = null;
            byte[] buffer = new byte[compressed.length * 2];
            this.decompressor.setInput(compressed);
            while (true) {
                byte[] result;
                int count;
                if ((count = this.decompressor.decompress(buffer)) == 0) {
                    if (decompressed != null) {
                        return ByteBuffer.wrap(decompressed);
                    }
                    if (this.needsDictionary) {
                        this.decompressor.setDictionary(CompressionDictionary.get(version));
                        this.needsDictionary = false;
                        continue;
                    }
                    throw new IllegalStateException();
                }
                if (count < buffer.length) {
                    if (decompressed == null) {
                        return ByteBuffer.wrap(buffer, 0, count);
                    }
                    result = Arrays.copyOf(decompressed, decompressed.length + count);
                    System.arraycopy(buffer, 0, result, decompressed.length, count);
                    return ByteBuffer.wrap(result);
                }
                if (decompressed == null) {
                    decompressed = buffer;
                    buffer = new byte[buffer.length];
                    continue;
                }
                result = Arrays.copyOf(decompressed, decompressed.length + buffer.length);
                System.arraycopy(buffer, 0, result, decompressed.length, buffer.length);
                decompressed = result;
            }
        }
        catch (ZipException x) {
            throw new SessionException(SessionStatus.PROTOCOL_ERROR, (Throwable)x);
        }
    }
}

