/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.internal.AbstractDispatchObject;
import org.fusesource.hawtdispatch.internal.ActiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.InactiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.MetricsCollector;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialDispatchQueue
extends AbstractDispatchObject
implements HawtDispatchQueue {
    protected volatile String label;
    protected final AtomicBoolean triggered = new AtomicBoolean();
    protected final ConcurrentLinkedQueue<Task> externalQueue = new ConcurrentLinkedQueue();
    private final LinkedList<Task> localQueue = new LinkedList();
    private final LinkedList<Task> sourceQueue = new LinkedList();
    private final ThreadLocal<Boolean> executing = new ThreadLocal();
    private MetricsCollector metricsCollector = InactiveMetricsCollector.INSTANCE;
    private boolean profile = false;

    public SerialDispatchQueue(String label) {
        this.label = label;
    }

    @Override
    public void execute(Task task) {
        assert (task != null);
        this.enqueue(this.metricsCollector.track(task));
    }

    @Override
    @Deprecated
    public void execute(Runnable runnable) {
        this.execute(new TaskWrapper(runnable));
    }

    @Override
    @Deprecated
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        this.executeAfter(delay, unit, new TaskWrapper(runnable));
    }

    @Override
    public LinkedList<Task> getSourceQueue() {
        return this.sourceQueue;
    }

    private void enqueue(Task runnable) {
        if (this.executing.get() != null) {
            this.localQueue.add(runnable);
        } else {
            this.externalQueue.add(runnable);
            this.triggerExecution();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.checkCollector();
        original = HawtDispatcher.CURRENT_QUEUE.get();
        HawtDispatcher.CURRENT_QUEUE.set(this);
        this.executing.set(Boolean.TRUE);
        try {
            while ((runnable = this.externalQueue.poll()) != null) {
                this.localQueue.add(runnable);
            }
lbl10:
            // 3 sources

            while (true) {
                if (this.isSuspended()) {
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable var5_13) {
            for (Runnable var7_16 : this.sourceQueue) {
                var7_16.run();
            }
            this.sourceQueue.clear();
            this.executing.remove();
            HawtDispatcher.CURRENT_QUEUE.set(original);
            this.triggered.set(false);
            v0 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
            if (!this.isSuspended() && !empty) {
                this.triggerExecution();
            }
            throw var5_13;
        }
        for (Runnable var4_10 : this.sourceQueue) {
            var4_10.run();
        }
        this.sourceQueue.clear();
        this.executing.remove();
        HawtDispatcher.CURRENT_QUEUE.set(original);
        this.triggered.set(false);
        v1 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
        if (!this.isSuspended() && !empty) {
            this.triggerExecution();
        }
        return;
lbl-1000:
        // 1 sources

        {
            runnable = this.localQueue.poll();
            if (runnable != null) ** GOTO lbl-1000
        }
        for (Runnable var4_12 : this.sourceQueue) {
            var4_12.run();
        }
        this.sourceQueue.clear();
        this.executing.remove();
        HawtDispatcher.CURRENT_QUEUE.set(original);
        this.triggered.set(false);
        v2 = empty = this.externalQueue.isEmpty() != false && this.localQueue.isEmpty() != false;
        if (!this.isSuspended() && !empty) {
            this.triggerExecution();
        }
        return;
lbl-1000:
        // 1 sources

        {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                var4_8 = Thread.currentThread();
                var4_8.getUncaughtExceptionHandler().uncaughtException(var4_8, e);
                ** continue;
            }
        }
    }

    protected void triggerExecution() {
        if (this.triggered.compareAndSet(false, true)) {
            this.getTargetQueue().execute(this);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isExecuting() {
        return this.executing.get() != null;
    }

    @Override
    public void assertExecuting() {
        assert (this.isExecuting()) : this.getDispatcher().assertMessage(this.getLabel());
    }

    @Override
    protected void onStartup() {
        this.triggerExecution();
    }

    @Override
    protected void onResume() {
        this.triggerExecution();
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.SERIAL_QUEUE;
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Task task) {
        this.getDispatcher().timerThread.addRelative(task, this, delay, unit);
    }

    @Override
    public DispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = this.getDispatcher().createQueue(label);
        rc.setTargetQueue(this);
        return rc;
    }

    @Override
    public HawtDispatcher getDispatcher() {
        HawtDispatchQueue target = this.getTargetQueue();
        if (target == null) {
            throw new UnsupportedOperationException();
        }
        return target.getDispatcher();
    }

    @Override
    public SerialDispatchQueue isSerialDispatchQueue() {
        return this;
    }

    @Override
    public ThreadDispatchQueue isThreadDispatchQueue() {
        return null;
    }

    @Override
    public GlobalDispatchQueue isGlobalDispatchQueue() {
        return null;
    }

    @Override
    public void profile(boolean profile) {
        this.profile = profile;
        this.checkCollector();
    }

    @Override
    public boolean profile() {
        return this.profile;
    }

    private void checkCollector() {
        if (this.profile() || this.getDispatcher().profile()) {
            if (this.metricsCollector == InactiveMetricsCollector.INSTANCE) {
                this.metricsCollector = new ActiveMetricsCollector(this);
                this.getDispatcher().track(this);
            }
        } else if (this.metricsCollector != InactiveMetricsCollector.INSTANCE) {
            this.metricsCollector = InactiveMetricsCollector.INSTANCE;
            this.getDispatcher().untrack(this);
        }
    }

    @Override
    public Metrics metrics() {
        return this.metricsCollector.metrics();
    }

    private int drains() {
        return this.getDispatcher().drains;
    }

    public String toString() {
        if (this.label == null) {
            return "serial queue";
        }
        return "serial queue { label: \"" + this.label + "\" }";
    }
}

