/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Producer;
import org.apache.camel.impl.EmptyProducerCache;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDynamicProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware,
CamelContextAware {
    protected static final Logger LOG = LoggerFactory.getLogger(SendDynamicProcessor.class);
    protected CamelContext camelContext;
    protected final String uri;
    protected final Expression expression;
    protected ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected String id;
    protected boolean ignoreInvalidEndpoint;
    protected int cacheSize;

    public SendDynamicProcessor(Expression expression) {
        this.uri = null;
        this.expression = expression;
    }

    public SendDynamicProcessor(String uri, Expression expression) {
        this.uri = uri;
        this.expression = expression;
    }

    public String toString() {
        return "sendTo(" + this.getExpression() + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ExchangePattern destinationExchangePattern;
        Endpoint endpoint;
        if (!this.isStarted()) {
            exchange.setException(new IllegalStateException("SendProcessor has not been started: " + this));
            callback.done(true);
            return true;
        }
        final ExchangePattern existingPattern = exchange.getPattern();
        Object recipient = null;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            endpoint = SendDynamicProcessor.resolveEndpoint(exchange, recipient);
            destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl(endpoint.getEndpointUri());
        }
        catch (Throwable e) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", e);
                }
            } else {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        return this.producerCache.doInAsyncProducer(endpoint, exchange, this.pattern, callback, new AsyncProducerCallback(){

            @Override
            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, Exchange exchange, ExchangePattern pattern, final AsyncCallback callback) {
                final Exchange target = SendDynamicProcessor.this.configureExchange(exchange, pattern, destinationExchangePattern, endpoint);
                LOG.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
                return asyncProducer.process(target, new AsyncCallback(){

                    @Override
                    public void done(boolean doneSync) {
                        target.setPattern(existingPattern);
                        callback.done(doneSync);
                    }
                });
            }
        });
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        } else {
            if (recipient instanceof Endpoint) {
                return (Endpoint)recipient;
            }
            recipient = exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern, ExchangePattern destinationExchangePattern, Endpoint endpoint) {
        if (destinationExchangePattern != null) {
            exchange.setPattern(destinationExchangePattern);
        } else if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
        return exchange;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                LOG.debug("DynamicSendTo {} is not using ProducerCache", (Object)this);
            } else if (this.cacheSize == 0) {
                this.producerCache = new ProducerCache(this, this.camelContext);
                LOG.debug("DynamicSendTo {} using ProducerCache with default cache size", (Object)this);
            } else {
                this.producerCache = new ProducerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("DynamicSendTo {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService(this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.producerCache);
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getUri() {
        return this.uri;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

