/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.event.CamelEvent;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

@UriEndpoint(scheme="spring-event", title="Spring Event", syntax="spring-event:name", consumerClass=EventConsumer.class, label="spring,eventbus")
public class EventEndpoint
extends DefaultEndpoint
implements ApplicationContextAware {
    private LoadBalancer loadBalancer;
    private ApplicationContext applicationContext;
    @UriPath(description="Name of endpoint")
    private String name;

    public EventEndpoint(String endpointUri, EventComponent component, String name) {
        super(endpointUri, component);
        this.applicationContext = component.getApplicationContext();
        this.name = name;
    }

    @Deprecated
    public EventEndpoint(String endpointUri) {
        super(endpointUri);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Producer createProducer() throws Exception {
        ObjectHelper.notNull(this.applicationContext, "applicationContext");
        return new DefaultProducer(this){

            @Override
            public void process(Exchange exchange) throws Exception {
                ApplicationEvent event = EventEndpoint.this.toApplicationEvent(exchange);
                EventEndpoint.this.applicationContext.publishEvent(event);
            }
        };
    }

    @Override
    public EventConsumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull(this.applicationContext, "applicationContext");
        EventConsumer answer = new EventConsumer(this, processor);
        this.configureConsumer(answer);
        return answer;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody(event);
        try {
            this.getLoadBalancer().process(exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Override
    public EventComponent getComponent() {
        return (EventComponent)super.getComponent();
    }

    public synchronized void consumerStarted(EventConsumer consumer) {
        this.getComponent().consumerStarted(this);
        this.getLoadBalancer().addProcessor(consumer.getProcessor());
    }

    public synchronized void consumerStopped(EventConsumer consumer) {
        this.getComponent().consumerStopped(this);
        this.getLoadBalancer().removeProcessor(consumer.getProcessor());
    }

    protected LoadBalancer createLoadBalancer() {
        return new TopicLoadBalancer();
    }

    protected ApplicationEvent toApplicationEvent(Exchange exchange) {
        ApplicationEvent event = exchange.getIn().getBody(ApplicationEvent.class);
        if (event != null) {
            return event;
        }
        return new CamelEvent(this, exchange);
    }
}

