/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.console.command.AbstractCommand;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateCommand
extends AbstractCommand {
    protected final String[] helpFile = new String[]{"Task Usage: Main create path/to/brokerA [create-options]", "Description:  Creates a runnable broker instance in the specified path.", "", "List Options:", "    --amqconf <file path>   Path to ActiveMQ conf file that will be used in the broker instance. Default is: conf/activemq.xml", "    --version               Display the version information.", "    -h,-?,--help            Display the create broker help information.", ""};
    protected final String DEFAULT_TARGET_ACTIVEMQ_CONF = "conf/activemq.xml";
    protected final String DEFAULT_BROKERNAME_XPATH = "/beans/broker/@brokerName";
    protected final String[] BASE_SUB_DIRS = new String[]{"bin", "conf"};
    protected final String BROKER_NAME_REGEX = "[$][{]brokerName[}]";
    protected String amqConf = "conf/activemq.xml";
    protected String[][] fileCopyMap = new String[][]{{"conf/log4j.properties", "conf/log4j.properties"}, {"conf/broker.ks", "conf/broker.ks"}, {"conf/broker.ts", "conf/broker.ts"}, {"conf/camel.xml", "conf/camel.xml"}, {"conf/jetty.xml", "conf/jetty.xml"}, {"conf/credentials.properties", "conf/credentials.properties"}};
    protected String[][] fileWriteMap = new String[][]{{"winActivemq", "bin/${brokerName}.bat"}, {"unixActivemq", "bin/${brokerName}"}};
    protected String brokerName;
    protected File amqHome;
    protected File targetAmqBase;
    private static final String winActivemqData = "@echo off\nset ACTIVEMQ_HOME=\"${activemq.home}\"\nset ACTIVEMQ_BASE=\"${activemq.base}\"\n\nset PARAM=%1\n:getParam\nshift\nif \"%1\"==\"\" goto end\nset PARAM=%PARAM% %1\ngoto getParam\n:end\n\n%ACTIVEMQ_HOME%/bin/activemq %PARAM%";
    private static final String unixActivemqData = "## Figure out the ACTIVEMQ_BASE from the directory this script was run from\nPRG=\"$0\"\nprogname=`basename \"$0\"`\nsaveddir=`pwd`\n# need this for relative symlinks\ndirname_prg=`dirname \"$PRG\"`\ncd \"$dirname_prg\"\nwhile [ -h \"$PRG\" ] ; do\n  ls=`ls -ld \"$PRG\"`\n  link=`expr \"$ls\" : '.*-> \\(.*\\)$'`\n  if expr \"$link\" : '.*/.*' > /dev/null; then\n    PRG=\"$link\"\n  else\n    PRG=`dirname \"$PRG\"`\"/$link\"\n  fi\ndone\nACTIVEMQ_BASE=`dirname \"$PRG\"`/..\ncd \"$saveddir\"\n\nACTIVEMQ_BASE=`cd \"$ACTIVEMQ_BASE\" && pwd`\n\nexport ACTIVEMQ_HOME=${activemq.home}\nexport ACTIVEMQ_BASE=$ACTIVEMQ_BASE\n\n${ACTIVEMQ_HOME}/bin/activemq \"$*\"";

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        this.context.print("Running create broker task...");
        this.amqHome = new File(System.getProperty("activemq.home"));
        for (String token : tokens) {
            block3: {
                this.targetAmqBase = new File(token);
                this.brokerName = this.targetAmqBase.getName();
                if (this.targetAmqBase.exists()) {
                    String resp;
                    BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        this.context.print("Target directory (" + this.targetAmqBase.getCanonicalPath() + ") already exists. Overwrite (y/n): ");
                        resp = console.readLine();
                        if (resp.equalsIgnoreCase("y") || resp.equalsIgnoreCase("yes")) break block3;
                    } while (!resp.equalsIgnoreCase("n") && !resp.equalsIgnoreCase("no"));
                    return;
                }
            }
            this.context.print("Creating directory: " + this.targetAmqBase.getCanonicalPath());
            this.targetAmqBase.mkdirs();
            this.createSubDirs(this.targetAmqBase, this.BASE_SUB_DIRS);
            this.writeFileMapping(this.targetAmqBase, this.fileWriteMap);
            this.copyActivemqConf(this.amqHome, this.targetAmqBase, this.amqConf);
            this.copyFileMapping(this.amqHome, this.targetAmqBase, this.fileCopyMap);
        }
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.startsWith("--amqconf")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Attributes to amqconf not specified"));
                return;
            }
            this.amqConf = tokens.remove(0);
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void createSubDirs(File target, String[] subDirs) throws IOException {
        for (String subDir : this.BASE_SUB_DIRS) {
            File subDirFile = new File(target, subDir);
            this.context.print("Creating directory: " + subDirFile.getCanonicalPath());
            subDirFile.mkdirs();
        }
    }

    protected void writeFileMapping(File targetBase, String[][] fileWriteMapping) throws IOException {
        for (String[] fileWrite : fileWriteMapping) {
            File dest = new File(targetBase, this.resolveParam("[$][{]brokerName[}]", this.brokerName, fileWrite[1]));
            this.context.print("Creating new file: " + dest.getCanonicalPath());
            this.writeFile(fileWrite[0], dest);
        }
    }

    protected void copyFileMapping(File srcBase, File targetBase, String[][] fileMapping) throws IOException {
        for (String[] fileMap : fileMapping) {
            File src = new File(srcBase, fileMap[0]);
            File dest = new File(targetBase, this.resolveParam("[$][{]brokerName[}]", this.brokerName, fileMap[1]));
            this.context.print("Copying from: " + src.getCanonicalPath() + "\n          to: " + dest.getCanonicalPath());
            this.copyFile(src, dest);
        }
    }

    protected void copyActivemqConf(File srcBase, File targetBase, String activemqConf) throws IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException {
        File src = new File(srcBase, activemqConf);
        if (!src.exists()) {
            throw new FileNotFoundException("File: " + src.getCanonicalPath() + " not found.");
        }
        File dest = new File(targetBase, "conf/activemq.xml");
        this.context.print("Copying from: " + src.getCanonicalPath() + "\n          to: " + dest.getCanonicalPath());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element docElem = builder.parse(src).getDocumentElement();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Attr brokerNameAttr = (Attr)xpath.evaluate("/beans/broker/@brokerName", docElem, XPathConstants.NODE);
        brokerNameAttr.setValue(this.brokerName);
        this.writeToFile(new DOMSource(docElem), dest);
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }

    private void writeFile(String typeName, File dest) throws IOException {
        String data;
        if (typeName.equals("winActivemq")) {
            data = winActivemqData;
            data = this.resolveParam("[$][{]activemq.home[}]", this.amqHome.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
            data = this.resolveParam("[$][{]activemq.base[}]", this.targetAmqBase.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
        } else if (typeName.equals("unixActivemq")) {
            data = unixActivemqData;
            data = this.resolveParam("[$][{]activemq.home[}]", this.amqHome.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
            data = this.resolveParam("[$][{]activemq.base[}]", this.targetAmqBase.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
        } else {
            throw new IllegalStateException("Unknown file type: " + typeName);
        }
        ByteBuffer buf = ByteBuffer.allocate(data.length());
        buf.put(data.getBytes());
        buf.flip();
        FileChannel destinationChannel = new FileOutputStream(dest).getChannel();
        destinationChannel.write(buf);
        destinationChannel.close();
    }

    private void writeToFile(Source src, File file) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer fileTransformer = tFactory.newTransformer();
        StreamResult res = new StreamResult(file);
        fileTransformer.transform(src, res);
    }

    private void copyFile(File from, File dest) throws IOException {
        if (!from.exists()) {
            return;
        }
        FileChannel sourceChannel = new FileInputStream(from).getChannel();
        FileChannel destinationChannel = new FileOutputStream(dest).getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        sourceChannel.close();
        destinationChannel.close();
    }

    private String resolveParam(String paramName, String paramValue, String target) {
        return target.replaceAll(paramName, paramValue);
    }
}

