/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.kerberos;

import java.io.IOException;
import org.alfresco.jlan.server.auth.asn.DERBitString;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERGeneralString;
import org.alfresco.jlan.server.auth.asn.DERInteger;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROctetString;
import org.alfresco.jlan.server.auth.asn.DERSequence;

public class EncKrbTicket {
    private int m_flags;
    private int m_encKeyType;
    private byte[] m_encKey;
    private String m_realm;
    private String m_principalName;
    private int m_authType = -1;
    private byte[] m_authData;

    public EncKrbTicket() {
    }

    public EncKrbTicket(byte[] blob) throws IOException {
        this.parseEncTicket(blob);
    }

    public final int getFlags() {
        return this.m_flags;
    }

    public final String getRealm() {
        return this.m_realm;
    }

    public final int getEncryptionKeyType() {
        return this.m_encKeyType;
    }

    public final byte[] getEncryptionKey() {
        return this.m_encKey;
    }

    public final int getAuthorizationDataType() {
        return this.m_authType;
    }

    public final byte[] getAuthorizationData() {
        return this.m_authData;
    }

    public void parseEncTicket(byte[] blob) throws IOException {
        DERBuffer derBuf = new DERBuffer(blob);
        DERObject derObj = derBuf.unpackObject();
        if (derObj instanceof DERSequence) {
            DERSequence derSeq = (DERSequence)derObj;
            block16: for (int idx = 0; idx < derSeq.numberOfObjects(); ++idx) {
                derObj = derSeq.getObjectAt(idx);
                if (derObj == null || !derObj.isTagged()) continue;
                switch (derObj.getTagNo()) {
                    case 0: {
                        if (!(derObj instanceof DERBitString)) continue block16;
                        DERBitString derBits = (DERBitString)derObj;
                        this.m_flags = derBits.intValue();
                        continue block16;
                    }
                    case 1: {
                        if (!(derObj instanceof DERSequence)) continue block16;
                        DERSequence derEncSeq = (DERSequence)derObj;
                        block17: for (int i = 0; i < derEncSeq.numberOfObjects(); ++i) {
                            derObj = derEncSeq.getObjectAt(i);
                            if (derObj == null || !derObj.isTagged()) continue;
                            switch (derObj.getTagNo()) {
                                case 0: {
                                    if (!(derObj instanceof DERInteger)) continue block17;
                                    DERInteger derInt = (DERInteger)derObj;
                                    this.m_encKeyType = (int)derInt.getValue();
                                    continue block17;
                                }
                                case 1: {
                                    if (!(derObj instanceof DEROctetString)) continue block17;
                                    DEROctetString derOct = (DEROctetString)derObj;
                                    this.m_encKey = derOct.getValue();
                                }
                            }
                        }
                        continue block16;
                    }
                    case 2: {
                        if (!(derObj instanceof DERGeneralString)) continue block16;
                        DERGeneralString derStr = (DERGeneralString)derObj;
                        this.m_realm = derStr.getValue();
                        continue block16;
                    }
                    case 3: {
                        continue block16;
                    }
                    case 4: {
                        continue block16;
                    }
                    case 5: {
                        continue block16;
                    }
                    case 6: {
                        continue block16;
                    }
                    case 7: {
                        continue block16;
                    }
                    case 8: {
                        continue block16;
                    }
                    case 9: {
                        continue block16;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[EncKrbTkt Flags=0x");
        str.append(Integer.toHexString(this.getFlags()));
        str.append(",Key=Type=");
        str.append(this.getEncryptionKeyType());
        str.append(",Len=");
        str.append(this.getEncryptionKey().length);
        str.append(",Realm=");
        str.append(this.getRealm());
        str.append("]");
        return str.toString();
    }
}

