/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.client.SMBInputStream;
import org.alfresco.jlan.client.SMBOutputStream;
import org.alfresco.jlan.client.SearchContext;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.info.DiskInfo;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.client.info.VolumeInfo;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBException;

public abstract class DiskSession
extends Session {
    public static final int DefaultInformationLevel = 1;
    public static final int Attributes = 1;
    public static final int WriteTime = 2;
    public static final int WriteDate = 4;

    protected DiskSession(PCShare shr, int dialect) {
        super(shr, dialect, null);
        this.setDeviceType(0);
    }

    @Override
    public void CloseSession() throws IOException, SMBException {
        super.CloseSession();
    }

    public abstract void CreateDirectory(String var1) throws IOException, SMBException;

    public abstract SMBFile CreateFile(String var1) throws IOException, SMBException;

    public abstract void DeleteDirectory(String var1) throws IOException, SMBException;

    public void DeleteFile(String fname) throws IOException, SMBException {
        this.DeleteFile(fname, 0);
    }

    public abstract void DeleteFile(String var1, int var2) throws IOException, SMBException;

    public boolean FileExists(String fname) {
        boolean sts = false;
        try {
            if (fname.startsWith("\\")) {
                if (this.getFileInformation(fname) != null) {
                    sts = true;
                }
            } else if (this.getFileInformation(PCShare.makePath(this.getWorkingDirectory(), fname)) != null) {
                sts = true;
            }
        }
        catch (SMBException ex) {
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sts;
    }

    protected void finalize() {
        if (!this.isClosed()) {
            try {
                this.CloseSession();
            }
            catch (SMBException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract DiskInfo getDiskInformation() throws IOException, SMBException;

    public abstract FileInfo getFileInformation(String var1, int var2) throws IOException, FileNotFoundException, SMBException;

    public final FileInfo getFileInformation(String fname) throws IOException, FileNotFoundException, SMBException {
        return this.getFileInformation(fname, 1);
    }

    public abstract VolumeInfo getVolumeInformation() throws IOException, SMBException;

    public final String getWorkingDirectory() {
        return this.getPCShare().getPath();
    }

    public final boolean isClosed() {
        return this.m_treeid == -1;
    }

    public abstract boolean isDirectory(String var1) throws IOException, SMBException;

    public abstract SMBFile OpenFile(String var1, int var2) throws IOException, SMBException;

    public SMBInputStream OpenInputStream(String fname, int flags) throws IOException, SMBException {
        SMBFile sfile = this.OpenFile(fname, flags);
        if (sfile == null) {
            return null;
        }
        return new SMBInputStream(sfile);
    }

    public SMBOutputStream OpenOutputStream(String fname, int flags) throws IOException, SMBException {
        SMBFile sfile = this.OpenFile(fname, flags);
        if (sfile == null) {
            return null;
        }
        return new SMBOutputStream(sfile);
    }

    public boolean RenameFile(String curnam, String newnam) throws IOException, SMBException {
        return this.RenameFile(curnam, newnam, 0);
    }

    public abstract boolean RenameFile(String var1, String var2, int var3) throws IOException, SMBException;

    public abstract void setFileInformation(String var1, FileInfo var2) throws IOException, SMBException;

    public abstract void setFileInformation(SMBFile var1, FileInfo var2) throws IOException, SMBException;

    public abstract void setFileAttributes(String var1, int var2) throws IOException, SMBException;

    public final void setWorkingDirectory(String wd) {
        this.getPCShare().setPath(wd);
    }

    public abstract SearchContext StartSearch(String var1, int var2, int var3) throws IOException, SMBException;

    public final SearchContext StartSearch(String dir, int attr) throws IOException, SMBException {
        return this.StartSearch(dir, attr, 1);
    }

    protected final boolean isValidFilePath(String path) {
        return path != null && !path.endsWith("\\");
    }
}

