/*
 * Decompiled with CFR 0.152.
 */
package nl.knaw.dans.common.dbflib;

import nl.knaw.dans.common.dbflib.DbfLibException;
import nl.knaw.dans.common.dbflib.Field;
import nl.knaw.dans.common.dbflib.ValueTooLargeException;

public abstract class Value {
    private final byte[] originalRaw;
    private final Field originalField;
    protected Object typed;

    protected Value(Field originalField, byte[] rawValue) {
        this.originalField = originalField;
        this.originalRaw = rawValue;
    }

    protected Value(Object aTypedValue) {
        this.typed = aTypedValue;
        this.originalRaw = null;
        this.originalField = null;
    }

    final Object getTypedValue() {
        if (this.typed == null) {
            this.typed = this.doGetTypedValue(this.originalRaw);
        }
        return this.typed;
    }

    final byte[] getRawValue(Field aField) throws DbfLibException {
        if (this.originalRaw != null && this.originalField.equals(aField)) {
            return this.originalRaw;
        }
        aField.validateTypedValue(this.typed);
        return this.doGetRawValue(aField);
    }

    protected abstract Object doGetTypedValue(byte[] var1);

    protected abstract byte[] doGetRawValue(Field var1) throws ValueTooLargeException;
}

