/*
 * Decompiled with CFR 0.152.
 */
package nl.geodienstencentrum.maven.plugin.sass.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Collection;
import nl.geodienstencentrum.maven.plugin.sass.AbstractSassMojo;
import org.apache.commons.io.DirectoryWalker;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="update-stylesheets", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class UpdateStylesheetsMojo
extends AbstractSassMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skip compiling Sass templates");
            return;
        }
        boolean buildRequired = true;
        try {
            buildRequired = this.buildRequired();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not check file timestamps", (Exception)e);
        }
        if (!buildRequired) {
            this.getLog().info((CharSequence)"Skip compiling Sass templates, no changes.");
            return;
        }
        this.getLog().info((CharSequence)"Compiling Sass templates");
        StringBuilder sassBuilder = new StringBuilder();
        this.buildBasicSassScript(sassBuilder);
        sassBuilder.append("Sass::Plugin.update_stylesheets");
        String sassScript = sassBuilder.toString();
        this.executeSassScript(sassScript);
    }

    private boolean buildRequired() throws IOException {
        if (!this.buildDirectory.exists()) {
            return true;
        }
        LastModifiedWalker sourceWalker = new LastModifiedWalker(this.getSassSourceDirectory());
        FilteredLastModifiedWalker targetWalker = new FilteredLastModifiedWalker(this.destination);
        if (sourceWalker.getCount() == 0 || targetWalker.getCount() == 0) {
            return true;
        }
        return sourceWalker.getYoungest() > targetWalker.getYoungest();
    }

    private class LastModifiedWalker
    extends DirectoryWalker<Void> {
        protected Long youngest;
        protected Long oldest;
        protected int count = 0;

        public LastModifiedWalker() {
        }

        public LastModifiedWalker(File startDirectory) throws IOException {
            this.walk(startDirectory, null);
            UpdateStylesheetsMojo.this.getLog().info((CharSequence)("Checked " + this.count + " files for " + startDirectory));
        }

        protected void handleFile(File file, int depth, Collection<Void> results) throws IOException {
            long lastMod = file.lastModified();
            this.youngest = this.youngest == null ? lastMod : Math.max(this.youngest, lastMod);
            this.oldest = this.oldest == null ? lastMod : Math.min(this.oldest, lastMod);
            ++this.count;
            super.handleFile(file, depth, results);
        }

        public Long getYoungest() {
            return this.youngest;
        }

        public Long getOldest() {
            return this.oldest;
        }

        public int getCount() {
            return this.count;
        }
    }

    private class FilteredLastModifiedWalker
    extends LastModifiedWalker {
        protected String filter;
        private PathMatcher pathMatcher;

        public FilteredLastModifiedWalker(File startDirectory) throws IOException {
            this(startDirectory, "**/*.css");
        }

        public FilteredLastModifiedWalker(File startDirectory, String filter) throws IOException {
            this.filter = filter;
            this.pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.filter);
            this.walk(startDirectory, null);
            UpdateStylesheetsMojo.this.getLog().info((CharSequence)("Checked " + this.count + " filtered (" + this.filter + ") files for " + startDirectory));
        }

        @Override
        protected void handleFile(File file, int depth, Collection<Void> results) throws IOException {
            if (this.pathMatcher.matches(file.toPath())) {
                super.handleFile(file, depth, results);
            }
        }
    }
}

