/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.screenshots;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotAndHtmlSource {
    private final File screenshot;
    private final File sourcecode;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenshotAndHtmlSource.class);

    public ScreenshotAndHtmlSource(File screenshot, File sourcecode) {
        this.screenshot = screenshot;
        this.sourcecode = sourcecode;
    }

    public ScreenshotAndHtmlSource(File screenshot) {
        this.screenshot = screenshot;
        this.sourcecode = null;
    }

    public File getScreenshotFile() {
        return this.screenshot;
    }

    public Optional<File> getSourcecode() {
        return Optional.fromNullable((Object)this.sourcecode);
    }

    public boolean wasTaken() {
        return this.screenshot != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScreenshotAndHtmlSource)) {
            return false;
        }
        ScreenshotAndHtmlSource that = (ScreenshotAndHtmlSource)o;
        if (this.screenshot == null) {
            return that.screenshot == null;
        }
        if (that.screenshot == null) {
            return this.screenshot == null;
        }
        try {
            return FileUtils.contentEquals((File)this.screenshot, (File)that.screenshot);
        }
        catch (IOException e) {
            return false;
        }
    }

    public int hashCode() {
        return this.screenshot != null ? this.screenshot.hashCode() : 0;
    }

    public boolean hasIdenticalScreenshotsAs(ScreenshotAndHtmlSource anotherScreenshotAndHtmlSource) {
        if (this.hasNoScreenshot() || anotherScreenshotAndHtmlSource.hasNoScreenshot()) {
            return false;
        }
        try {
            File screenshotTargetDirectory = new File(this.getScreenshotFile().getParent());
            return FileUtils.checksumCRC32((File)this.getScreenshotFile(screenshotTargetDirectory)) == FileUtils.checksumCRC32((File)anotherScreenshotAndHtmlSource.getScreenshotFile(screenshotTargetDirectory));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to compare screenshots: " + e.getMessage());
            return false;
        }
    }

    public File getScreenshotFile(File screenshotTargetDirectory) {
        return new File(screenshotTargetDirectory, this.getScreenshotFile().getName());
    }

    public boolean hasNoScreenshot() {
        return this.getScreenshotFile() == null;
    }
}

