/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.WebElement;

public class FileToUpload {
    private final String filename;
    static final String WINDOWS_PATH_PATTERN = "^[A-Z]:\\\\.*";
    private static Pattern fullWindowsPath = Pattern.compile("^[A-Z]:\\\\.*");

    public FileToUpload(String filename) {
        this.filename = this.isOnTheClasspath(filename) ? this.getFileFromResourcePath(filename) : this.getFileFromFileSystem(filename);
    }

    private boolean isOnTheClasspath(String filename) {
        if (FileToUpload.isOnTheUnixFileSystem(filename) || FileToUpload.isOnTheWindowsFileSystem(filename)) {
            return false;
        }
        return this.resourceOnClasspath(filename) != null;
    }

    private URL resourceOnClasspath(String filename) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        return cldr.getResource(filename);
    }

    public static boolean isOnTheWindowsFileSystem(String filename) {
        return SystemUtils.IS_OS_WINDOWS && new File(filename).exists();
    }

    public static boolean isAFullWindowsPath(String filename) {
        return fullWindowsPath.matcher(filename).find();
    }

    public static boolean isOnTheUnixFileSystem(String filename) {
        return SystemUtils.IS_OS_UNIX && new File(filename).exists();
    }

    private String getFileFromResourcePath(String filename) {
        return this.resourceOnClasspath(filename).getFile();
    }

    private String getFileFromFileSystem(String filename) {
        File fileToUpload = new File(filename);
        return fileToUpload.getAbsolutePath();
    }

    public void to(WebElement uploadFileField) {
        uploadFileField.sendKeys(new CharSequence[]{this.osSpecificPathOf(this.filename)});
    }

    private String osSpecificPathOf(String fileToUpload) {
        if (FileToUpload.isAFullWindowsPath(fileToUpload)) {
            return this.windowsNative(fileToUpload);
        }
        return fileToUpload;
    }

    private String windowsNative(String fileToUpload) {
        String bareFilename = fileToUpload.charAt(0) == '/' ? fileToUpload.substring(1) : fileToUpload;
        return StringUtils.replace((String)bareFilename, (String)"/", (String)"\\");
    }
}

