/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternWithPredicate
extends Pattern {
    private Pattern basePattern;
    private Expression predicate;

    public PatternWithPredicate(Pattern basePattern, Expression predicate) {
        this.basePattern = basePattern;
        this.predicate = predicate;
        this.adoptChildExpression(basePattern);
        this.adoptChildExpression(predicate);
    }

    public Expression getPredicate() {
        return this.predicate;
    }

    public Pattern getBasePattern() {
        return this.basePattern;
    }

    @Override
    public void bindCurrent(LocalBinding binding) {
        if (this.predicate.isCallOn(Current.class)) {
            this.predicate = new LocalVariableReference(binding);
        } else if (ExpressionTool.callsFunction(this.predicate, Current.FN_CURRENT, false)) {
            PatternWithPredicate.replaceCurrent(this.predicate, binding);
        }
        this.basePattern.bindCurrent(binding);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this, this.basePattern, OperandRole.ATOMIC_SEQUENCE), new Operand(this, this.predicate, OperandRole.FOCUS_CONTROLLED_ACTION));
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.basePattern.promote(offer, parent);
        this.predicate = this.predicate.promote(offer);
        offer.bindingList = savedBindingList;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        int n = ExpressionTool.allocateSlots(this.predicate, nextFree, slotManager);
        return this.basePattern.allocateSlots(slotManager, n);
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        if (!this.basePattern.matches(item, context)) {
            return false;
        }
        return this.matchesPredicate(item, context);
    }

    private boolean matchesPredicate(Item item, XPathContext context) throws XPathException {
        XPathContextMinor c2 = context.newMinorContext();
        ManualIterator si = new ManualIterator(item);
        c2.setCurrentIterator(si);
        try {
            return this.predicate.effectiveBooleanValue(c2);
        }
        catch (XPathException.Circularity e) {
            throw e;
        }
        catch (XPathException ex) {
            if ("XTDE0640".equals(ex.getErrorCodeLocalPart())) {
                throw ex;
            }
            XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", ex);
            err.setXPathContext(c2);
            err.setErrorCodeQName(ex.getErrorCodeQName());
            err.setLocation(this.getLocation());
            c2.getController().recoverableError(err);
            return false;
        }
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.basePattern.matchesBeneathAnchor(node, anchor, context) && this.matchesPredicate(node, context);
    }

    @Override
    public UType getUType() {
        return this.basePattern.getUType();
    }

    @Override
    public int getFingerprint() {
        return this.basePattern.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.basePattern.getItemType();
    }

    @Override
    public int getDependencies() {
        return this.predicate.getDependencies();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        Iterator[] pair = new Iterator[]{this.basePattern.iterateSubExpressions(), new MonoIterator<Expression>(this.predicate)};
        return new MultiIterator<Expression>(pair);
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.basePattern = this.basePattern.typeCheck(visitor, contextItemType);
        ContextItemStaticInfo cit = new ContextItemStaticInfo(this.basePattern.getItemType(), false);
        this.predicate = this.predicate.typeCheck(visitor, cit);
        return this;
    }

    @Override
    public Pattern optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.basePattern = this.basePattern.optimize(visitor, contextInfo);
        ContextItemStaticInfo cit = new ContextItemStaticInfo(this.basePattern.getItemType(), false);
        this.predicate = this.predicate.optimize(visitor, cit);
        return this;
    }

    @Override
    public Pattern convertToTypedPattern(String val) throws XPathException {
        Pattern b2 = this.basePattern.convertToTypedPattern(val);
        if (b2 == this.basePattern) {
            return this;
        }
        return new PatternWithPredicate(b2, this.predicate);
    }

    @Override
    public String toString() {
        return this.basePattern.toString() + "[" + this.predicate.toString() + "]";
    }

    @Override
    public Pattern copy(RebindingMap rebindings) {
        PatternWithPredicate n = new PatternWithPredicate(this.basePattern.copy(rebindings), this.predicate.copy(rebindings));
        ExpressionTool.copyLocationInfo(this, n);
        return n;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("p.withPredicate");
        this.basePattern.export(presenter);
        this.predicate.export(presenter);
        presenter.endElement();
    }
}

