/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanExpressionPattern
extends Pattern {
    private Expression expression;

    public BooleanExpressionPattern(Expression expression) {
        this.expression = expression;
        this.setPriority(1.0);
    }

    @Override
    public Iterable<Operand> operands() {
        return new Operand(this, this.expression, OperandRole.SINGLE_ATOMIC);
    }

    @Override
    public UType getUType() {
        if (this.expression instanceof InstanceOfExpression) {
            return ((InstanceOfExpression)this.expression).getRequiredItemType().getUType();
        }
        return UType.ANY;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.expression, nextFree, slotManager);
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.expression);
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        ContextItemStaticInfo cit = ContextItemStaticInfo.DEFAULT;
        this.expression = this.expression.typeCheck(visitor, cit);
        return this;
    }

    @Override
    public boolean matches(Item item, XPathContext context) {
        XPathContextMinor c2 = context.newMinorContext();
        ManualIterator iter = new ManualIterator(item);
        c2.setCurrentIterator(iter);
        try {
            return this.expression.effectiveBooleanValue(c2);
        }
        catch (XPathException e) {
            return false;
        }
    }

    @Override
    public ItemType getItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public String toString() {
        return ".[" + this.expression.toString() + "]";
    }

    public boolean equals(Object other) {
        return other instanceof BooleanExpressionPattern && ((BooleanExpressionPattern)other).expression.equals(this.expression);
    }

    public int hashCode() {
        return 0x7AEFFEA9 ^ this.expression.hashCode();
    }

    @Override
    public Pattern copy() {
        BooleanExpressionPattern n = new BooleanExpressionPattern(this.expression.copy());
        ExpressionTool.copyLocationInfo(this, n);
        return n;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("p.booleanExp");
        this.expression.export(presenter);
        presenter.endElement();
    }

    public Expression getExpression() {
        return this.expression;
    }
}

