/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.om.AbstractItem;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleArrayItem
extends AbstractItem
implements ArrayItem {
    public static final SimpleArrayItem EMPTY_ARRAY = new SimpleArrayItem(new ArrayList<Sequence>());
    private List<Sequence> members;

    public SimpleArrayItem(List<Sequence> members) {
        this.members = members;
    }

    public static SimpleArrayItem makeSimpleArrayItem(SequenceIterator input) throws XPathException {
        Item item;
        ArrayList<Sequence> members = new ArrayList<Sequence>();
        while ((item = input.next()) != null) {
            members.add(item);
        }
        return new SimpleArrayItem(members);
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        ArrayList<AtomicValue> list = new ArrayList<AtomicValue>(this.members.size());
        for (Sequence seq : this.members) {
            Item item;
            SequenceIterator iter = seq.iterate();
            while ((item = iter.next()) != null) {
                AtomicSequence atoms = item.atomize();
                for (AtomicValue atom : atoms) {
                    list.add(atom);
                }
            }
        }
        return new AtomicArray(list);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public Sequence get(int index) throws XPathException {
        if (index < 0 || index >= this.members.size()) {
            throw new XPathException("Array index (" + (index + 1) + ") out of range (1 to " + this.members.size() + ")", "FOAY0001");
        }
        return this.members.get(index);
    }

    @Override
    public int size() {
        return this.members.size();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public Iterator<Sequence> iterator() {
        return this.members.iterator();
    }

    @Override
    public ArrayItem remove(int index) throws XPathException {
        if (index < 0 || index >= this.members.size()) {
            throw new XPathException("Position is not in range", "FOAY0001");
        }
        ArrayList<Sequence> newList = new ArrayList<Sequence>(this.members.size() - 1);
        newList.addAll(this.members.subList(0, index));
        newList.addAll(this.members.subList(index + 1, this.members.size()));
        return new SimpleArrayItem(newList);
    }

    @Override
    public ArrayItem concat(ArrayItem other) {
        ArrayList<Sequence> newList = new ArrayList<Sequence>(this.members.size() + other.size());
        newList.addAll(this.members);
        for (Sequence s : other) {
            newList.add(s);
        }
        return new SimpleArrayItem(newList);
    }

    @Override
    public SequenceType getMemberType() {
        return SequenceType.ANY_SEQUENCE;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        return ArrayItemType.ANY_ARRAY_TYPE;
    }

    @Override
    public StructuredQName getFunctionName() {
        return null;
    }

    @Override
    public String getDescription() {
        return "array";
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        return this.get((int)((IntegerValue)args[0].head()).longValue() - 1);
    }

    @Override
    public boolean deepEquals(Function other, XPathContext context, AtomicComparer comparer, int flags) throws XPathException {
        if (other instanceof ArrayItem) {
            ArrayItem that = (ArrayItem)other;
            if (this.size() != that.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (DeepEqual.deepEqual(this.get(i).iterate(), that.get(i).iterate(), comparer, context, flags)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("Effective boolean value is not defined for arrays", "FORG0006");
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("An array does not have a string value");
    }

    @Override
    public CharSequence getStringValueCS() {
        throw new UnsupportedOperationException("An array does not have a string value");
    }

    @Override
    public void export(ExpressionPresenter out) {
        out.startElement("array");
        out.emitAttribute("size", this.size() + "");
        for (Sequence mem : this.members) {
            Literal.exportValue(mem, out);
        }
        out.endElement();
    }

    @Override
    public List<Sequence> getMembers() {
        return this.members;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer(256);
        buffer.append("[");
        for (Sequence seq : this.members) {
            if (buffer.length() > 1) {
                buffer.append(", ");
            }
            buffer.append(seq.toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

