/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.ComponentCode;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetComponent;
import net.sf.saxon.style.XSLGlobalParam;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XSLGlobalVariable
extends StyleElement
implements StylesheetComponent {
    private SlotManager slotManager;
    protected SourceBinding sourceBinding = new SourceBinding(this);
    protected GlobalVariable compiledVariable = null;
    private int state = 0;
    protected boolean redundant = false;

    public SourceBinding getSourceBinding() {
        return this.sourceBinding;
    }

    public StructuredQName getVariableQName() {
        return this.sourceBinding.getVariableQName();
    }

    public StructuredQName getObjectName() {
        return this.sourceBinding.getVariableQName();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isGlobal() {
        return this.isTopLevel();
    }

    public void postValidate() throws XPathException {
        this.sourceBinding.postValidate();
    }

    public int getConstructType() {
        return 206;
    }

    public GlobalVariable getCompiledVariable() {
        return this.compiledVariable;
    }

    public XSLGlobalVariable() {
        this.sourceBinding.setProperty(2, true);
    }

    protected int getPermittedAttributes() {
        return 6592;
    }

    public ComponentCode getCompiledProcedure() throws XPathException {
        GlobalVariable gv = this.getCompiledVariable();
        if (gv == null) {
            gv = this instanceof XSLGlobalParam ? new GlobalParam() : new GlobalVariable();
            gv.setPackageData(this.getCompilation().getPackageData());
            gv.makeDeclaringComponent(this.getVisibility(), this.getContainingPackage());
            gv.setDeclaredVisibility(this.getDeclaredVisibility());
            gv.setVariableQName(this.sourceBinding.getVariableQName());
            RetainedStaticContext rsc = this.makeRetainedStaticContext();
            gv.setRetainedStaticContext(rsc);
            if (gv.getBody() != null) {
                gv.getBody().setRetainedStaticContext(rsc);
            }
            this.compiledVariable = gv;
        }
        return gv;
    }

    public SymbolicName getSymbolicName() {
        return new SymbolicName(206, this.getObjectName());
    }

    public void checkCompatibility(Component component) throws XPathException {
        GlobalVariable other = (GlobalVariable)component.getCode();
        TypeHierarchy th = component.getDeclaringPackage().getConfiguration().getTypeHierarchy();
        int relation = th.sequenceTypeRelationship(this.getRequiredType(), other.getRequiredType());
        if (relation != 0) {
            this.compileError("The declared type of the overriding variable $" + this.getVariableQName().getDisplayName() + " is different from that of the overridden variable", "XTSE3070");
        }
    }

    public SourceBinding getBindingInformation(StructuredQName name) {
        if (name.equals(this.sourceBinding.getVariableQName())) {
            return this.sourceBinding;
        }
        return null;
    }

    public void prepareAttributes() throws XPathException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable", "XTDE0640");
        }
        this.state = 1;
        this.sourceBinding.prepareAttributes(this.getPermittedAttributes());
        this.state = 2;
    }

    public void index(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.indexVariableDeclaration(decl);
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.slotManager = this.getConfiguration().makeSlotManager();
        this.sourceBinding.validate();
        if (this.sourceBinding.hasProperty(2048) && !this.isXslt30Processor()) {
            this.compileError("Static variables and parameters require XSLT 3.0 to be enabled");
        }
    }

    public boolean isAssignable() {
        return this.sourceBinding.hasProperty(64);
    }

    public boolean isDeclaration() {
        return true;
    }

    public boolean isInstruction() {
        return false;
    }

    public SequenceType getRequiredType() {
        return this.sourceBinding.getInferredType(true);
    }

    public void fixupReferences() throws XPathException {
        this.sourceBinding.fixupReferences();
        super.fixupReferences();
    }

    public void compileDeclaration(Compilation compilation, ComponentDeclaration decl) throws XPathException {
        if (!this.redundant) {
            this.sourceBinding.handleSequenceConstructor(compilation, decl);
            GlobalVariable inst = this.getCompiledVariable();
            if (inst == null) {
                inst = new GlobalVariable();
                inst.setPackageData(this.getCompilation().getPackageData());
                inst.makeDeclaringComponent(this.getVisibility(), this.getContainingPackage());
                inst.setVariableQName(this.sourceBinding.getVariableQName());
            }
            if (this.sourceBinding.isStatic()) {
                GroundedValue value = compilation.getStaticVariable(this.sourceBinding.getVariableQName());
                if (value == null) {
                    throw new AssertionError();
                }
                Literal select = Literal.makeLiteral(value);
                select.setRetainedStaticContext(this.makeRetainedStaticContext());
                inst.setSelectExpression(select);
            } else {
                Expression select = this.sourceBinding.getSelectExpression();
                inst.setSelectExpression(select);
            }
            inst.setRetainedStaticContext(this.makeRetainedStaticContext());
            this.initializeBinding(inst);
            inst.setAssignable(this.isAssignable());
            inst.setRequiredType(this.getRequiredType());
            this.sourceBinding.fixupBinding(inst);
            this.compiledVariable = inst;
            Component overridden = this.getOverriddenComponent();
            if (overridden != null) {
                this.checkCompatibility(overridden);
            }
        }
    }

    protected void initializeBinding(GlobalVariable var) throws XPathException {
        Expression select = var.getSelectExpression();
        Expression exp2 = select;
        if (exp2 != null) {
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                exp2 = select.simplify().typeCheck(visitor, new ContextItemStaticInfo(Type.ITEM_TYPE, true));
            }
            catch (XPathException err) {
                this.compileError(err);
            }
            exp2 = XSLGlobalVariable.makeTraceInstruction(this, exp2);
            this.allocateLocalSlots(exp2);
        }
        if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
            var.setContainsLocals(this.slotManager);
        }
        if (exp2 != select) {
            var.setSelectExpression(exp2);
        }
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public void optimize(ComponentDeclaration declaration) throws XPathException {
        if (!this.redundant && this.compiledVariable.getSelectExpression() != null) {
            Expression exp2 = this.compiledVariable.getSelectExpression();
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            Optimizer opt = this.getConfiguration().obtainOptimizer();
            try {
                if (opt.getOptimizationLevel() != 0) {
                    ExpressionTool.resetPropertiesWithinSubtree(exp2);
                    exp2 = exp2.optimize(visitor, new ContextItemStaticInfo(AnyNodeTest.getInstance(), true));
                }
            }
            catch (XPathException err) {
                err.maybeSetLocation(this.getLocation());
                this.compileError(err);
            }
            this.allocateLocalSlots(exp2);
            if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
                this.compiledVariable.setContainsLocals(this.slotManager);
            }
            if (exp2 != this.compiledVariable.getSelectExpression()) {
                this.compiledVariable.setSelectExpression(exp2);
            }
        }
    }

    public void setRedundant(boolean redundant) {
        this.redundant = redundant;
    }

    public void generateByteCode(Optimizer opt) {
    }
}

