/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class UnicodeNormalizer
extends ProxyReceiver {
    private Normalizer normalizer;

    public UnicodeNormalizer(String form, Receiver next) throws XPathException {
        super(next);
        int fb;
        if (form.equals("NFC")) {
            fb = 2;
        } else if (form.equals("NFD")) {
            fb = 0;
        } else if (form.equals("NFKC")) {
            fb = 3;
        } else if (form.equals("NFKD")) {
            fb = 1;
        } else {
            XPathException err = new XPathException("Unknown normalization form " + form);
            err.setErrorCode("SESU0011");
            throw err;
        }
        this.normalizer = new Normalizer(fb, this.getConfiguration());
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        this.nextReceiver.attribute(nameCode, typeCode, this.normalizer.normalize(value), locationId, properties);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (Whitespace.isWhite(chars)) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            this.nextReceiver.characters(this.normalizer.normalize(chars), locationId, properties);
        }
    }
}

