package org.gwtwidgets.server.spring.hb4gwt;


import java.lang.reflect.Method;

import net.sf.hibernate4gwt.core.HibernateBeanManager;
import net.sf.hibernate4gwt.gwt.HibernateRPCHelper;
import com.google.gwt.user.server.rpc.RPC;

import org.gwtwidgets.server.spring.GWTRPCServiceExporter;

import com.google.gwt.user.server.rpc.RPCRequest;

/**
 * Incorporates <a href="http://hibernate4gwt.sourceforge.net/">Hibernate4GWT's</a> <code>HibernateBeanManager</code>.
 * The concept is similar to <code>HibernateRemoteService</code>: RPC objects are merged into the current
 * Hibernate session and are detached on their way out. Instances must be provided with a 
 * <code>HibernateBeanManager</code>.
 *  
 * @author George Georgovassilis, g.georgovassilis[at]gmail.com
 *
 */
public class HB4GWTRPCServiceExporter extends GWTRPCServiceExporter {

	private HibernateBeanManager beanManager;

	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		if (getBeanManager()==null)
			throw new Exception("HibernateBeanManager not set");
		HibernateRPCHelper.initClassLoader();
	}

	public HibernateBeanManager getBeanManager() {
		return beanManager;
	}

	public void setBeanManager(HibernateBeanManager beanManager) {
		this.beanManager = beanManager;
	}

	public String invokeMethodOnService(Object service, Method targetMethod, Object[] targetParameters,
			RPCRequest rpcRequest) throws Exception {
		HibernateRPCHelper.parseInputParameters(rpcRequest, beanManager, getThreadLocalRequest().getSession());
		Object result = targetMethod.invoke(service, targetParameters);
		result = HibernateRPCHelper.parseReturnValue(result, beanManager);
		String encodedResult = RPC.encodeResponseForSuccess(rpcRequest.getMethod(), result, rpcRequest
				.getSerializationPolicy());
		return encodedResult;
	}

}
