/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gwtwidgets.server.spring;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.ServletContextAware;

import com.google.gwt.user.client.rpc.RemoteService;

/**
 * Interface for RPC exporters.
 *  
 * @author George Georgovassilis, g.georgovassilis[at]gmail.com
 *
 */
public interface RPCServiceExporter extends HttpRequestHandler, InitializingBean, ServletContextAware  {

	/**
	 * Set the service object to which RPCs should be delegated.
	 * @param service
	 */
	void setService(Object service);
	
	/**
	 * 
	 * @param interfaces
	 */
	void setServiceInterfaces(Class<RemoteService>[] interfaces);
	
	void setResponseCachingDisabled(boolean caching);
}
