/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j.function;

import net.objecthunter.exp4j.function.Function;

public class Functions {
    private static final int INDEX_SIN = 0;
    private static final int INDEX_COS = 1;
    private static final int INDEX_TAN = 2;
    private static final int INDEX_LOG = 3;
    private static final int INDEX_LOG1P = 4;
    private static final int INDEX_ABS = 5;
    private static final int INDEX_ACOS = 6;
    private static final int INDEX_ASIN = 7;
    private static final int INDEX_ATAN = 8;
    private static final int INDEX_CBRT = 9;
    private static final int INDEX_CEIL = 10;
    private static final int INDEX_FLOOR = 11;
    private static final int INDEX_SINH = 12;
    private static final int INDEX_SQRT = 13;
    private static final int INDEX_TANH = 14;
    private static final int INDEX_COSH = 15;
    private static final int INDEX_MAX = 16;
    private static final int INDEX_MIN = 17;
    private static final int INDEX_POW = 18;
    private static final int INDEX_EXP = 19;
    private static final int INDEX_EXPM1 = 20;
    private static final int INDEX_LOG10 = 21;
    private static final int INDEX_LOG2 = 22;
    private static final Function[] builtinFunctions = new Function[23];

    public static Function getBuiltinFunction(String name) {
        switch (name) {
            case "sin": {
                return builtinFunctions[0];
            }
            case "cos": {
                return builtinFunctions[1];
            }
            case "tan": {
                return builtinFunctions[2];
            }
            case "asin": {
                return builtinFunctions[7];
            }
            case "acos": {
                return builtinFunctions[6];
            }
            case "atan": {
                return builtinFunctions[8];
            }
            case "sinh": {
                return builtinFunctions[12];
            }
            case "cosh": {
                return builtinFunctions[15];
            }
            case "tanh": {
                return builtinFunctions[14];
            }
            case "abs": {
                return builtinFunctions[5];
            }
            case "log": {
                return builtinFunctions[3];
            }
            case "log10": {
                return builtinFunctions[21];
            }
            case "log2": {
                return builtinFunctions[22];
            }
            case "log1p": {
                return builtinFunctions[4];
            }
            case "ceil": {
                return builtinFunctions[10];
            }
            case "floor": {
                return builtinFunctions[11];
            }
            case "max": {
                return builtinFunctions[16];
            }
            case "min": {
                return builtinFunctions[17];
            }
            case "sqrt": {
                return builtinFunctions[13];
            }
            case "cbrt": {
                return builtinFunctions[9];
            }
            case "pow": {
                return builtinFunctions[18];
            }
            case "exp": {
                return builtinFunctions[19];
            }
            case "expm1": {
                return builtinFunctions[20];
            }
        }
        return null;
    }

    static {
        Functions.builtinFunctions[0] = new Function("sin"){

            @Override
            public double apply(double ... args) {
                return Math.sin(args[0]);
            }
        };
        Functions.builtinFunctions[1] = new Function("cos"){

            @Override
            public double apply(double ... args) {
                return Math.cos(args[0]);
            }
        };
        Functions.builtinFunctions[2] = new Function("tan"){

            @Override
            public double apply(double ... args) {
                return Math.tan(args[0]);
            }
        };
        Functions.builtinFunctions[3] = new Function("log"){

            @Override
            public double apply(double ... args) {
                return Math.log(args[0]);
            }
        };
        Functions.builtinFunctions[22] = new Function("log2"){

            @Override
            public double apply(double ... args) {
                return Math.log(args[0]) / Math.log(2.0);
            }
        };
        Functions.builtinFunctions[21] = new Function("log10"){

            @Override
            public double apply(double ... args) {
                return Math.log10(args[0]);
            }
        };
        Functions.builtinFunctions[4] = new Function("log1p"){

            @Override
            public double apply(double ... args) {
                return Math.log1p(args[0]);
            }
        };
        Functions.builtinFunctions[5] = new Function("abs"){

            @Override
            public double apply(double ... args) {
                return Math.abs(args[0]);
            }
        };
        Functions.builtinFunctions[6] = new Function("acos"){

            @Override
            public double apply(double ... args) {
                return Math.acos(args[0]);
            }
        };
        Functions.builtinFunctions[7] = new Function("asin"){

            @Override
            public double apply(double ... args) {
                return Math.asin(args[0]);
            }
        };
        Functions.builtinFunctions[8] = new Function("atan"){

            @Override
            public double apply(double ... args) {
                return Math.atan(args[0]);
            }
        };
        Functions.builtinFunctions[9] = new Function("cbrt"){

            @Override
            public double apply(double ... args) {
                return Math.cbrt(args[0]);
            }
        };
        Functions.builtinFunctions[11] = new Function("floor"){

            @Override
            public double apply(double ... args) {
                return Math.floor(args[0]);
            }
        };
        Functions.builtinFunctions[12] = new Function("sinh"){

            @Override
            public double apply(double ... args) {
                return Math.sinh(args[0]);
            }
        };
        Functions.builtinFunctions[13] = new Function("sqrt"){

            @Override
            public double apply(double ... args) {
                return Math.sqrt(args[0]);
            }
        };
        Functions.builtinFunctions[14] = new Function("tanh"){

            @Override
            public double apply(double ... args) {
                return Math.tanh(args[0]);
            }
        };
        Functions.builtinFunctions[15] = new Function("cosh"){

            @Override
            public double apply(double ... args) {
                return Math.cosh(args[0]);
            }
        };
        Functions.builtinFunctions[10] = new Function("ceil"){

            @Override
            public double apply(double ... args) {
                return Math.ceil(args[0]);
            }
        };
        Functions.builtinFunctions[18] = new Function("pow", 2){

            @Override
            public double apply(double ... args) {
                return Math.pow(args[0], args[1]);
            }
        };
        Functions.builtinFunctions[19] = new Function("exp", 1){

            @Override
            public double apply(double ... args) {
                return Math.exp(args[0]);
            }
        };
        Functions.builtinFunctions[20] = new Function("expm1", 1){

            @Override
            public double apply(double ... args) {
                return Math.expm1(args[0]);
            }
        };
    }
}

