/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Query;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.domain.DataModel;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.MappingToUrl;
import net.hasor.dataway.config.Result;
import net.hasor.dataway.daos.ApiDetailQuery;
import net.hasor.dataway.web.BasicController;
import net.hasor.web.annotation.Post;
import net.hasor.web.annotation.QueryParameter;
import net.hasor.web.annotation.RequestBody;
import net.hasor.web.objects.JsonRenderEngine;
import net.hasor.web.render.RenderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MappingToUrl(value="/api/smoke")
@RenderType(value="json", engineType=JsonRenderEngine.class)
public class SmokeController
extends BasicController {
    protected static Logger logger = LoggerFactory.getLogger(SmokeController.class);
    @Inject
    private DataQL executeDataQL;

    @Post
    public Result<Map<String, Object>> doSmoke(final @QueryParameter(value="id") String apiId, @RequestBody Map<String, Object> requestBody) throws IOException {
        if (!apiId.equalsIgnoreCase(requestBody.get("id").toString())) {
            throw new IllegalArgumentException("id Parameters of the ambiguity.");
        }
        QueryResult queryDetail = new ApiDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
            {
                this.put("apiId", apiId);
            }
        });
        String strCodeType = ((ObjectModel)queryDetail.getData()).getValue("codeType").asString();
        String strCodeValue = ((ObjectModel)queryDetail.getData()).getObject("codeInfo").getValue("codeValue").asString();
        Map strRequestBody = (Map)requestBody.get("requestBody");
        if ("sql".equalsIgnoreCase(strCodeType)) {
            strCodeValue = DatawayUtils.evalCodeValueForSQL(strCodeValue, strRequestBody);
        }
        try {
            Query dataQLQuery = this.executeDataQL.createQuery(strCodeValue);
            QueryResult queryResult = dataQLQuery.execute(strRequestBody);
            DataModel resultData = queryResult.getData();
            this.updateSchema(apiId, strRequestBody, resultData);
            return DatawayUtils.queryResultToResult(queryResult);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return DatawayUtils.exceptionToResult(e);
        }
    }

    private void updateSchema(String apiID, Map<String, Object> requestData, DataModel responseData) {
    }
}

