/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dataway.service;

import com.alibaba.fastjson.JSON;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import net.hasor.dataql.DataQL;
import net.hasor.dataql.Finder;
import net.hasor.dataql.QueryResult;
import net.hasor.dataql.compiler.QueryModel;
import net.hasor.dataql.compiler.qil.QIL;
import net.hasor.dataql.domain.ObjectModel;
import net.hasor.dataql.runtime.QueryHelper;
import net.hasor.dataway.config.DatawayUtils;
import net.hasor.dataway.config.LoggerUtils;
import net.hasor.dataway.daos.ReleaseDetailQuery;
import net.hasor.utils.StringUtils;
import net.hasor.web.Invoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApiCallService {
    protected static Logger logger = LoggerFactory.getLogger(ApiCallService.class);
    @Inject
    @Named(value="net.hasor.dataway.config.DatawayModule")
    private DataQL dataQL;
    @Inject
    private DataQL executeDataQL;

    public Map<String, Object> doCall(Invoker invoker) {
        DatawayUtils.resetLocalTime();
        LoggerUtils loggerUtils = LoggerUtils.create();
        HttpServletRequest httpRequest = invoker.getHttpRequest();
        final String httpMethod = httpRequest.getMethod().toUpperCase().trim();
        final String requestURI = httpRequest.getRequestURI();
        loggerUtils.addLog("apiMethod", httpMethod);
        loggerUtils.addLog("apiPath", requestURI);
        String script = null;
        try {
            QueryResult queryResult = new ReleaseDetailQuery(this.dataQL).execute(new HashMap<String, String>(){
                {
                    this.put("apiMethod", httpMethod);
                    this.put("apiPath", URLDecoder.decode(requestURI, "UTF-8"));
                }
            });
            ObjectModel dataModel = (ObjectModel)queryResult.getData();
            script = dataModel.getValue("script").asString();
            loggerUtils.addLog("scriptType", dataModel.getValue("scriptType").asString());
            loggerUtils.addLog("releaseID", dataModel.getValue("releaseID").asString());
            loggerUtils.addLog("apiID", dataModel.getValue("apiID").asString());
        }
        catch (Exception e) {
            logger.error("requestFailed - " + loggerUtils.logException(e).toJson(), (Throwable)e);
            return DatawayUtils.exceptionToResult(e).getResult();
        }
        try {
            String jsonBody;
            Object jsonParam = "GET".equalsIgnoreCase(httpMethod) ? httpRequest.getParameterMap() : (StringUtils.isNotBlank((String)(jsonBody = invoker.getJsonBodyString())) ? JSON.parseObject((String)jsonBody) : new HashMap());
            if (jsonParam != null) {
                loggerUtils.addLog("paramRootKeys", jsonParam.keySet());
            }
            Set varNames = this.executeDataQL.getShareVarMap().keySet();
            QueryModel queryModel = QueryHelper.queryParser((String)script);
            QIL compiler = QueryHelper.queryCompiler((QueryModel)queryModel, varNames, (Finder)this.executeDataQL.getFinder());
            loggerUtils.addLog("compilerTime", DatawayUtils.currentLostTime());
            QueryResult execute = this.executeDataQL.createQuery(compiler).execute(jsonParam);
            loggerUtils.addLog("executionTime", execute.executionTime());
            loggerUtils.addLog("lifeCycleTime", DatawayUtils.currentLostTime());
            loggerUtils.addLog("code", execute.getCode());
            logger.info("requestSuccess - " + loggerUtils.toJson());
            return DatawayUtils.queryResultToResult(execute).getResult();
        }
        catch (Exception e) {
            logger.error("requestFailed - " + loggerUtils.logException(e).toJson(), (Throwable)e);
            return DatawayUtils.exceptionToResult(e).getResult();
        }
    }
}

