/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.dao.impl.CampagneDao;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.utils.AssertTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class CampagneServiceImpl
implements CampagneService {
    private static final Logger LOG = LoggerFactory.getLogger(CampagneServiceImpl.class);
    @Autowired
    private GenericDao dao;

    @Override
    public long countCampagnes() {
        return this.dao.count(Campagne.class);
    }

    @Override
    public void createCampagne(Campagne campagne) throws DataConstraintException {
        LOG.info("createCampagne " + campagne.getNom());
        this.dao.create((AbstractModel)campagne);
    }

    @Override
    public void deleteCampagne(Campagne campagne) throws DataConstraintException {
        AssertTools.assertNotNull((Object)campagne);
        LOG.info("deleteCampagne " + campagne.getIdCampagne());
        try {
            this.dao.delete((AbstractModel)campagne);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public List<String> listCampagneProgrammes() {
        return this.dao.list(CampagneDao.CRITERIA_DISTINCT_CAMPAGNE_PROGRAMMES);
    }

    @Override
    public List<Campagne> listCampagnes(Utilisateur utilisateur) {
        AssertTools.assertNotNull((Object)utilisateur);
        if (utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
            return this.dao.readList(Campagne.class, new String[]{"nom"});
        }
        SortedSet<Campagne> campagnes = this.listCampagnesForUser(utilisateur);
        return new ArrayList<Campagne>(campagnes);
    }

    @Override
    public SortedSet<Campagne> listCampagnesForUser(Utilisateur utilisateur) {
        TreeSet<Campagne> campagnes = new TreeSet<Campagne>();
        campagnes.addAll(utilisateur.getCampagnesCreees());
        campagnes.addAll(utilisateur.getCampagnesDroits().keySet());
        for (Lot lot : utilisateur.getLotsCrees()) {
            campagnes.add(lot.getCampagne());
        }
        for (Lot lot : utilisateur.getLotsDroits().keySet()) {
            campagnes.add(lot.getCampagne());
        }
        return campagnes;
    }

    @Override
    public Campagne loadCampagne(Integer idCampagne) throws DataNotFoundException {
        AssertTools.assertNotNull((Object)idCampagne);
        return (Campagne)this.dao.read(Campagne.class, (Serializable)idCampagne);
    }

    @Override
    public Campagne loadCampagne(String nom) throws DataNotFoundException {
        AssertTools.assertNotEmpty((String)nom);
        return (Campagne)this.dao.read(Campagne.class, "nom", (Serializable)((Object)nom));
    }

    @Override
    public void refreshCampagne(Campagne campagne) {
        AssertTools.assertNotNull((Object)campagne);
        this.dao.refresh((AbstractModel)campagne);
    }

    @Override
    public void updateCampagne(Campagne campagne) throws DataConstraintException {
        LOG.info("updateCampagne " + campagne.getIdCampagne());
        try {
            this.dao.update((AbstractModel)campagne);
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
    }

    @Override
    public boolean updateOrdeleteCampagneEnabled(Campagne campagne, Utilisateur utilisateur) {
        return utilisateur.getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR || utilisateur.getIdPersonne() == campagne.getCreateur().getIdPersonne();
    }
}

