/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.sphinx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kr.motd.maven.os.DetectionException;
import kr.motd.maven.os.Detector;
import kr.motd.maven.sphinx.Sha256;
import kr.motd.maven.sphinx.SphinxException;
import kr.motd.maven.sphinx.SphinxRunnerLogger;
import net.sourceforge.plantuml.UmlDiagram;

public class SphinxRunner {
    private static final OsDetector osDetector = new OsDetector();
    public static final String DEFAULT_BINARY_URL = "https://github.com/trustin/sphinx-binary/releases/download/v0.8.2/sphinx." + osDetector.executableSuffix();
    private static final String VERSION;
    private static final String USER_AGENT;
    private final String binaryUrl;
    private final File binaryCacheDir;
    private final Map<String, String> environments;
    private final SphinxRunnerLogger logger;
    private final String plantUmlCommand;

    public SphinxRunner(String binaryUrl, File binaryCacheDir, Map<String, String> environments, String dotBinary, SphinxRunnerLogger logger) {
        this.binaryUrl = Objects.requireNonNull(binaryUrl, "binaryUrl");
        if (!(binaryUrl.startsWith("http://") || binaryUrl.startsWith("https://") || binaryUrl.startsWith("file:"))) {
            throw new IllegalArgumentException("binaryUrl must start with 'file:', 'http://' or 'https://': " + binaryUrl);
        }
        this.binaryCacheDir = Objects.requireNonNull(binaryCacheDir, "binaryCacheDir");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.environments = new HashMap<String, String>(Objects.requireNonNull(environments, "environments"));
        StringBuilder plantUmlCommandBuf = new StringBuilder();
        plantUmlCommandBuf.append("java ");
        plantUmlCommandBuf.append("-Djava.awt.headless=true ");
        plantUmlCommandBuf.append("-jar ");
        plantUmlCommandBuf.append(SphinxRunner.findPlantUmlJar().getPath().replace("\\", "\\\\"));
        if (dotBinary != null) {
            plantUmlCommandBuf.append(" -graphvizdot ");
            plantUmlCommandBuf.append(dotBinary.replace("\\", "\\\\"));
        }
        this.plantUmlCommand = plantUmlCommandBuf.toString();
    }

    public final int run(File workingDir, List<String> args) {
        Objects.requireNonNull(workingDir, "workingDir");
        Objects.requireNonNull(args, "args");
        if (args.isEmpty()) {
            throw new IllegalArgumentException("args is empty.");
        }
        Path sphinxBinary = this.downloadSphinxBinary();
        ArrayList<String> fullArgs = new ArrayList<String>();
        fullArgs.add(sphinxBinary.toString());
        fullArgs.addAll(args);
        ProcessBuilder builder = new ProcessBuilder(fullArgs);
        Map<String, String> env = builder.environment();
        builder.directory(workingDir);
        this.configureProcessBuilder(builder);
        env.put("LANG", "en_US.UTF-8");
        env.put("LC_ALL", "en_US.UTF-8");
        env.put("TZ", "UTC");
        env.put("plantuml", this.plantUmlCommand);
        env.putAll(this.environments);
        try {
            long startTime = System.nanoTime();
            Process process = builder.start();
            process.getOutputStream().close();
            this.redirect(process.getInputStream(), process.getErrorStream());
            int exitCode = process.waitFor();
            this.logger.log("Sphinx exited with code " + exitCode + ". Took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) + "ms.");
            return exitCode;
        }
        catch (Exception e) {
            throw new SphinxException("Failed to run Sphinx: " + e, e);
        }
    }

    protected void configureProcessBuilder(ProcessBuilder builder) {
    }

    private void redirect(final InputStream stdout, final InputStream stderr) {
        if (stdout != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SphinxRunner.this.redirectStdout(stdout);
                    }
                    catch (Throwable t) {
                        SphinxRunner.this.logger.log("Failed to redirect stdout: " + t);
                    }
                    finally {
                        try {
                            stdout.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, "sphinx-redirect-stdout").start();
        }
        if (stderr != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SphinxRunner.this.redirectStderr(stderr);
                    }
                    catch (Throwable t) {
                        SphinxRunner.this.logger.log("Failed to redirect stderr: " + t);
                    }
                    finally {
                        try {
                            stdout.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }, "sphinx-redirect-stderr").start();
        }
    }

    protected void redirectStdout(InputStream stdout) throws Exception {
        this.redirect(stdout, System.out);
    }

    protected void redirectStderr(InputStream stderr) throws Exception {
        this.redirect(stderr, System.out);
    }

    protected void redirect(InputStream in, OutputStream out) throws Exception {
        int readBytes;
        byte[] buf = new byte[8192];
        while ((readBytes = in.read(buf)) >= 0) {
            if (readBytes <= 0) continue;
            out.write(buf, 0, readBytes);
        }
    }

    private static File findPlantUmlJar() {
        return SphinxRunner.findJar(UmlDiagram.class, "PlantUML JAR");
    }

    private static File findJar(Class<?> type, String name) {
        File f;
        CodeSource codeSource = type.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new SphinxException("failed to get the location of " + name + " (CodeSource not available)");
        }
        URL url = codeSource.getLocation();
        if (!"file".equals(url.getProtocol()) || !url.getPath().toLowerCase(Locale.US).endsWith(".jar")) {
            throw new SphinxException("failed to get the location of " + name + " (unexpected URL: " + url + ')');
        }
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException ignored) {
            f = new File(url.getPath());
        }
        return f;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path downloadSphinxBinary() {
        Object object;
        Path tmpSha256;
        Path tmpBinary;
        URI binaryUri;
        block36: {
            if (this.binaryUrl.startsWith("file:")) {
                File f;
                block34: {
                    URL url = null;
                    f = null;
                    try {
                        url = new URL(this.binaryUrl);
                        f = new File(url.toURI());
                    }
                    catch (Exception ignored) {
                        if (url == null) break block34;
                        f = new File(url.getPath());
                    }
                }
                if (f == null) throw new SphinxException("failed to locate Sphinx binary: " + this.binaryUrl);
                if (f.exists()) return f.toPath();
                throw new SphinxException("failed to locate Sphinx binary: " + this.binaryUrl);
            }
            File binaryDir = new File(this.binaryCacheDir, this.binaryUrl.replaceAll("[/\\\\<>:\"|?*]", "_"));
            binaryDir.mkdirs();
            if (!binaryDir.isDirectory()) {
                throw new SphinxException("failed to create a cache directory: " + binaryDir);
            }
            String binaryName = "sphinx." + osDetector.executableSuffix();
            String sha256Name = binaryName + ".sha256";
            Path binary = new File(binaryDir, binaryName).toPath();
            Path sha256 = new File(binaryDir, sha256Name).toPath();
            if (Files.exists(binary, new LinkOption[0])) {
                return binary;
            }
            binaryUri = URI.create(this.binaryUrl);
            URI sha256Uri = URI.create(this.binaryUrl + ".sha256");
            tmpBinary = null;
            tmpSha256 = null;
            tmpBinary = SphinxRunner.newTempExecutableFile(binary.getParent(), binaryName);
            this.download(binaryUri, tmpBinary);
            tmpSha256 = SphinxRunner.newTempRegularFile(binary.getParent(), sha256Name);
            this.download(sha256Uri, tmpSha256);
            List<String> sha256Lines = Files.readAllLines(tmpSha256, StandardCharsets.US_ASCII);
            if (sha256Lines.size() != 1) throw new SphinxException("invalid content: " + sha256Uri);
            if (!sha256Lines.get(0).matches("^[0-9a-fA-F]{64}(?:\\s.*$|$)")) {
                throw new SphinxException("invalid content: " + sha256Uri);
            }
            Sha256 digest = new Sha256();
            byte[] buffer = new byte[65536];
            FileInputStream in = new FileInputStream(tmpBinary.toFile());
            object = null;
            try {
                int readBytes;
                while ((readBytes = in.read(buffer)) >= 0) {
                    if (readBytes == 0) continue;
                    digest.update(buffer, 0, readBytes);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            byte[] actualSha256Sum = new byte[digest.getDigestLen()];
            digest.finishDigest(actualSha256Sum, 0);
            if (!new BigInteger(sha256Lines.get(0), 16).equals(new BigInteger(1, actualSha256Sum))) {
                throw new SphinxException("mismatching checksum: " + binaryUri);
            }
            Files.move(tmpSha256, sha256, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            tmpSha256 = null;
            Files.move(tmpBinary, binary, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            tmpBinary = null;
            object = binary;
            if (tmpSha256 == null) break block36;
            try {
                Files.deleteIfExists(tmpSha256);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (tmpBinary == null) return object;
        try {
            Files.deleteIfExists(tmpBinary);
            return object;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
        catch (SphinxException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new SphinxException("failed to download Sphinx binary at: " + binaryUri, e2);
                }
            }
            catch (Throwable throwable) {
                if (tmpSha256 != null) {
                    try {
                        Files.deleteIfExists(tmpSha256);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (tmpBinary == null) throw throwable;
                try {
                    Files.deleteIfExists(tmpBinary);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static Path newTempExecutableFile(Path dir, String name) throws IOException {
        if (osDetector.isWindows()) {
            return Files.createTempFile(dir, name + '.', ".tmp", new FileAttribute[0]);
        }
        return Files.createTempFile(dir, name + '.', ".tmp", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x")));
    }

    private static Path newTempRegularFile(Path dir, String name) throws IOException {
        if (osDetector.isWindows()) {
            return Files.createTempFile(dir, name + '.', ".tmp", new FileAttribute[0]);
        }
        return Files.createTempFile(dir, name + '.', ".tmp", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--")));
    }

    private void download(URI uri, Path path) {
        URL url;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        block33: while (true) {
            this.logger.log("Download " + url);
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                conn.setRequestProperty("Accept-Encoding", "identity");
                conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
                conn.setRequestProperty("Cache-Control", "no-cache");
                conn.setRequestProperty("Pragma", "no-cache");
                conn.setRequestProperty("User-Agent", USER_AGENT);
                conn.setUseCaches(false);
                switch (conn.getResponseCode()) {
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: 
                    case 308: {
                        URI newUri;
                        String location = conn.getHeaderField("Location");
                        if (location == null) {
                            throw new SphinxException("missing 'Location' header in a redirect response: " + url);
                        }
                        try {
                            newUri = URI.create(location);
                        }
                        catch (Exception e) {
                            throw new SphinxException("invalid 'Location' header in a redirect response: " + url);
                        }
                        if (!newUri.isAbsolute()) {
                            throw new SphinxException("relative 'Location' header in a redirect response: " + url);
                        }
                        url = newUri.toURL();
                        continue block33;
                    }
                    case 200: {
                        break;
                    }
                    default: {
                        throw new SphinxException("unexpected response code '" + conn.getResponseCode() + "':" + url);
                    }
                }
                String contentLength = conn.getHeaderField("Content-Length");
                long lastLogTimeNanos = System.nanoTime();
                try (InputStream in = conn.getInputStream();){
                    byte[] buffer = new byte[65536];
                    long progress = 0L;
                    try (FileOutputStream out = new FileOutputStream(path.toFile());){
                        int readBytes;
                        while ((readBytes = in.read(buffer)) >= 0) {
                            if (readBytes == 0) continue;
                            out.write(buffer, 0, readBytes);
                            progress += (long)readBytes;
                            long currentTimeNanos = System.nanoTime();
                            if (currentTimeNanos - lastLogTimeNanos < TimeUnit.SECONDS.toNanos(1L)) continue;
                            this.logger.log("Download " + progress + '/' + (contentLength != null ? contentLength : "?"));
                            lastLogTimeNanos = currentTimeNanos;
                        }
                    }
                }
                return;
            }
            catch (SphinxException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SphinxException("failed to download: " + url, e);
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
                continue;
            }
            break;
        }
    }

    static {
        Properties versionProps = new Properties();
        try {
            versionProps.load(SphinxRunner.class.getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        VERSION = versionProps.getProperty("version");
        if (VERSION == null) {
            throw new IllegalStateException("cannot determine the plugin version");
        }
        USER_AGENT = SphinxRunner.class.getSimpleName() + '/' + VERSION;
    }

    private static class OsDetector
    extends Detector {
        private String classifier;

        private OsDetector() {
        }

        boolean isWindows() {
            return this.classifier().startsWith("windows");
        }

        String executableSuffix() {
            if (this.isWindows()) {
                return this.classifier() + ".exe";
            }
            return this.classifier();
        }

        private String classifier() {
            if (this.classifier != null) {
                return this.classifier;
            }
            Properties properties = new Properties();
            try {
                this.detect(properties, Collections.emptyList());
            }
            catch (DetectionException e) {
                throw new SphinxException(e.getMessage());
            }
            this.classifier = properties.getProperty("os.detected.classifier");
            return this.classifier;
        }

        protected void log(String s) {
        }

        protected void logProperty(String s, String s1) {
        }
    }
}

