/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.sphinx;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kr.motd.maven.sphinx.SphinxException;
import kr.motd.maven.sphinx.SphinxRunner;
import kr.motd.maven.sphinx.SphinxRunnerLogger;
import kr.motd.maven.sphinx.SphinxUtil;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Proxy;
import org.codehaus.doxia.sink.Sink;

@Mojo(name="generate", defaultPhase=LifecyclePhase.SITE, requiresReports=true)
public class SphinxMojo
extends AbstractMojo
implements MavenReport {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="sphinx.asReport", defaultValue="false", alias="asReport")
    private boolean asReport;
    @Parameter(property="sphinx.name", defaultValue="Sphinx-Docs", alias="name")
    private String name;
    @Parameter(property="sphinx.description", defaultValue="Documentation using Python Sphinx Package", alias="description")
    private String description;
    private static final String sphinxSiteSubDirectory = "sphinx";
    private static final String[] CRUFTS = new String[]{"css/maven-base.css", "css/maven-theme.css", "css/print.css", "css/site.css", "css", "images/logos/build-by-maven-black.png", "images/logos/build-by-maven-white.png", "images/logos/maven-feather.png", "images/logos", "images/collapsed.gif", "images/expanded.gif", "images/external.png", "images/icon_error_sml.gif", "images/icon_info_sml.gif", "images/icon_success_sml.gif", "images/icon_warning_sml.gif", "images/newwindow.png", "images"};
    @Parameter(property="sphinx.srcDir", defaultValue="${basedir}/src/site/sphinx", required=true)
    private File sourceDirectory;
    @Parameter(property="sphinx.cfgDir")
    private File configDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="sphinx.binUrl")
    private String binaryUrl = SphinxRunner.DEFAULT_BINARY_URL;
    @Parameter(property="sphinx.binCacheDir", defaultValue="${settings.localRepository}/kr/motd/maven/sphinx-binary", required=true)
    private File binaryCacheDir;
    @Parameter(property="sphinx.env")
    private Map<String, String> environments = Collections.emptyMap();
    @Parameter(property="sphinx.dotBin")
    private String dotBinary;
    @Parameter(property="sphinx.builder", required=true, alias="builder", defaultValue="html")
    private String builder;
    @Parameter(property="sphinx.tags", alias="tags")
    private List<String> tags;
    @Parameter(property="sphinx.verbose", defaultValue="true", required=true, alias="verbose")
    private boolean verbose;
    @Parameter(property="sphinx.traceback", defaultValue="true", required=true, alias="traceback")
    private boolean traceback;
    @Parameter(property="sphinx.warningAsErrors", defaultValue="false", required=true, alias="warningAsErrors")
    private boolean warningsAsErrors;
    @Parameter(property="sphinx.force", defaultValue="false", required=true, alias="force")
    private boolean force;
    @Parameter(property="sphinx.skip", defaultValue="false", required=true, alias="skip")
    private boolean skip;
    @Parameter(property="sphinx.useDoctreeCache", defaultValue="false", required=true, alias="useDocTreeCache")
    private boolean useDoctreeCache;
    @Parameter(property="sphinx.doctreeCacheDir", defaultValue="${project.reporting.outputDirectory}/.doctrees", required=true, alias="doctreeCacheDir")
    private File doctreeCacheDir;
    @Parameter(property="sphinx.useMakeMode", defaultValue="false", required=true, alias="useMakeMode")
    private boolean useMakeMode;

    public void execute() throws MojoExecutionException {
        File doctreeCacheDir;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Sphinx execution.");
            return;
        }
        File sourceDirectory = SphinxMojo.canonicalize(this.sourceDirectory);
        File outputDirectory = this.getReportOutputDirectory();
        File binaryCacheDir = SphinxMojo.canonicalize(this.binaryCacheDir);
        File file = doctreeCacheDir = this.useDoctreeCache ? SphinxMojo.canonicalize(this.doctreeCacheDir) : null;
        if (this.isHtmlReport()) {
            new File(sourceDirectory.getPath() + "/index.rst").setLastModified(System.currentTimeMillis());
        }
        this.configureProxy();
        try {
            SphinxRunner sphinxRunner = new SphinxRunner(this.binaryUrl, binaryCacheDir, this.environments, "".equals(this.dotBinary) ? null : this.dotBinary, new SphinxRunnerLogger(){

                @Override
                public void log(String msg) {
                    SphinxMojo.this.getLog().info((CharSequence)msg);
                }
            });
            this.getLog().info((CharSequence)("Running Sphinx; output will be placed in " + outputDirectory));
            List<String> args = this.getSphinxRunnerCmdLine(sourceDirectory, outputDirectory, doctreeCacheDir);
            if (sphinxRunner.run(sourceDirectory, args) != 0) {
                throw new MavenReportException("Sphinx report generation failed");
            }
            SphinxUtil.convertLineSeparators(outputDirectory);
            if (!this.asReport) {
                SphinxMojo.deleteCruft(outputDirectory);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run the report", e);
        }
    }

    private static File canonicalize(File directory) throws MojoExecutionException {
        if (directory == null) {
            return null;
        }
        try {
            directory.mkdirs();
            return directory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to create a directory: " + directory, (Exception)e);
        }
    }

    private void configureProxy() {
        Proxy proxy;
        if (this.session != null && (proxy = this.session.getSettings().getActiveProxy()) != null && proxy.getProtocol() != null && proxy.getProtocol().toLowerCase().startsWith("http")) {
            for (String protocol : Arrays.asList("http", "https")) {
                System.setProperty(protocol + ".proxyHost", proxy.getHost());
                System.setProperty(protocol + ".proxyPort", String.valueOf(proxy.getPort()));
                if (proxy.getUsername() != null && proxy.getPassword() != null) {
                    System.setProperty(protocol + ".proxyUser", proxy.getUsername());
                    System.setProperty(protocol + ".proxyPassword", proxy.getPassword());
                }
                if (proxy.getNonProxyHosts() == null) continue;
                System.setProperty(protocol + ".nonProxyHosts", proxy.getNonProxyHosts());
            }
            if (System.getProperty("jdk.http.auth.tunneling.disabledSchemes") == null) {
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            }
            if (System.getProperty("https.protocols") == null) {
                System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            }
        }
    }

    private static void deleteCruft(final File outputDirectory) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (String c : CRUFTS) {
                    new File(outputDirectory, c.replace('/', File.separatorChar)).delete();
                }
            }
        });
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.execute();
        }
        catch (SphinxException e) {
            MavenReportException cause = new MavenReportException(e.getMessage());
            if (e.getCause() != null) {
                cause.initCause(e.getCause());
            }
            throw cause;
        }
        catch (Exception e) {
            throw new MavenReportException("Error generating a Sphinx report:", e);
        }
    }

    private boolean isHtmlReport() {
        return this.asReport && "html".equals(this.builder);
    }

    public String getOutputName() {
        if (this.isHtmlReport()) {
            return "sphinx/index";
        }
        return "Python-Sphinx";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    public void setReportOutputDirectory(File outputDirectory) {
    }

    public File getReportOutputDirectory() {
        File actual = this.asReport ? new File(this.outputDirectory.getPath() + File.separator + sphinxSiteSubDirectory) : this.outputDirectory;
        try {
            return SphinxMojo.canonicalize(actual);
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)("Failed to canonicalize: " + actual), (Throwable)e);
            return actual;
        }
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private List<String> getSphinxRunnerCmdLine(File sourceDirectory, File outputDirectory, File doctreeCacheDir) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.useMakeMode ? "-M" : "-b");
        args.add(this.builder);
        if (this.verbose) {
            args.add("-v");
        } else {
            args.add("-Q");
        }
        if (this.traceback) {
            args.add("-T");
        }
        if (this.warningsAsErrors) {
            args.add("-W");
        }
        if (this.force) {
            args.add("-a");
            args.add("-E");
        }
        if (this.configDirectory != null) {
            args.add("-c");
            args.add(this.configDirectory.getPath());
        }
        if (doctreeCacheDir != null) {
            args.add("-d");
            args.add(doctreeCacheDir.getPath());
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            for (String tag : this.tags) {
                args.add("-t");
                args.add(tag);
            }
        }
        args.add("-n");
        args.add(sourceDirectory.getPath());
        args.add(outputDirectory.getPath());
        return args;
    }
}

