/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.EventListenerConfigurator;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.InjectionSettingsFactory;
import org.hibernate.ejb.Version;
import org.hibernate.ejb.connection.InjectedDataSourceConnectionProvider;
import org.hibernate.ejb.instrument.InterceptFieldClassFileTransformer;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.hibernate.ejb.transaction.JoinableCMTTransactionFactory;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.ejb.util.LogHelper;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.event.EventListeners;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.reflection.java.xml.XMLContext;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.transaction.JDBCTransactionFactory;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.jboss.util.file.ArchiveBrowser;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Configuration
implements Serializable {
    private static final String IMPLEMENTATION_NAME = HibernatePersistence.class.getName();
    private static Log log = LogFactory.getLog(Ejb3Configuration.class);
    private AnnotationConfiguration cfg;
    private SettingsFactory settingsFactory = new InjectionSettingsFactory();
    private EventListenerConfigurator listenerConfigurator;
    private PersistenceUnitTransactionType transactionType;
    private static final String META_INF_ORM_XML = "META-INF/orm.xml";

    public Ejb3Configuration() {
        this.cfg = new AnnotationConfiguration(this.settingsFactory);
        this.cfg.setEntityNotFoundDelegate(new EntityNotFoundDelegate(){

            public void handleEntityNotFound(String entityName, Serializable id) {
                ObjectNotFoundException e = new ObjectNotFoundException(id, entityName);
                throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id, e);
            }
        });
        this.listenerConfigurator = new EventListenerConfigurator(this);
    }

    public void setDataSource(DataSource ds) {
        if (ds != null) {
            HashMap<String, DataSource> cpInjection = new HashMap<String, DataSource>();
            cpInjection.put("dataSource", ds);
            ((InjectionSettingsFactory)this.settingsFactory).setConnectionProviderInjectionData(cpInjection);
            this.setProperty("hibernate.connection.provider_class", InjectedDataSourceConnectionProvider.class.getName());
        }
    }

    private EntityManagerFactory createFactory(PersistenceMetadata metadata, Map overrides) {
        log.debug((Object)("Creating Factory: " + metadata.getName()));
        HashMap<String, Object> workingVars = new HashMap<String, Object>();
        workingVars.put("hibernate.ejb.persistenceUnitName", metadata.getName());
        if (StringHelper.isNotEmpty(metadata.getJtaDatasource())) {
            this.setProperty("hibernate.connection.datasource", metadata.getJtaDatasource());
        } else if (StringHelper.isNotEmpty(metadata.getNonJtaDatasource())) {
            this.setProperty("hibernate.connection.datasource", metadata.getNonJtaDatasource());
        }
        this.defineTransactionType((Object)metadata.getTransactionType(), workingVars);
        if (metadata.getClasses().size() > 0) {
            workingVars.put("hibernate.ejb.classes", metadata.getClasses());
        }
        if (metadata.getPackages().size() > 0) {
            workingVars.put("hibernate.ejb.packages", metadata.getPackages());
        }
        if (metadata.getMappingFiles().size() > 0) {
            workingVars.put("hibernate.ejb.xml_files", metadata.getMappingFiles());
        }
        if (metadata.getHbmfiles().size() > 0) {
            workingVars.put("hibernate.hbmxml.files", metadata.getHbmfiles());
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)metadata.getProps());
        if (overrides != null) {
            props.putAll((Map<?, ?>)overrides);
        }
        return this.createEntityManagerFactory(props, workingVars);
    }

    public EntityManagerFactory createEntityManagerFactory(String emName, Map integration) {
        try {
            log.debug((Object)("Trying to find persistence unit: " + emName));
            integration = integration == null ? (integration = CollectionHelper.EMPTY_MAP) : Collections.unmodifiableMap(integration);
            Enumeration<URL> xmls = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            while (xmls.hasMoreElements()) {
                URL url = xmls.nextElement();
                log.trace((Object)("Analyse of persistence.xml: " + url));
                List<PersistenceMetadata> metadataFiles = PersistenceXmlLoader.deploy(url, integration, this.cfg.getEntityResolver());
                for (PersistenceMetadata metadata : metadataFiles) {
                    JarVisitor.Filter[] filters = this.getFilters(metadata.getProps(), integration, metadata.getMappingFiles());
                    if (metadata.getProvider() != null && !IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProvider())) continue;
                    log.trace((Object)"Archive to be processed by hibernate Entity Manager implementation found");
                    URL jarURL = JarVisitor.getJarURLFromURLEntry(url, "/META-INF/persistence.xml");
                    JarVisitor visitor = JarVisitor.getVisitor(jarURL, filters);
                    if (metadata.getName() == null) {
                        metadata.setName(visitor.getUnqualifiedJarName());
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Persistence unit name: " + metadata.getName()));
                    }
                    log.trace((Object)("emname:" + emName + " metadata: " + metadata.getName()));
                    if (emName == null && xmls.hasMoreElements()) {
                        throw new PersistenceException("No name provided and several persistence units found");
                    }
                    if (emName != null && !metadata.getName().equals(emName)) continue;
                    Ejb3Configuration.addMetadataFromVisitor(visitor, metadata);
                    for (String jarFile : metadata.getJarFiles()) {
                        visitor = JarVisitor.getVisitor(jarFile, filters);
                        Ejb3Configuration.addMetadataFromVisitor(visitor, metadata);
                    }
                    return this.createFactory(metadata, integration);
                }
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof PersistenceException) {
                throw (PersistenceException)e;
            }
            throw new PersistenceException(e);
        }
    }

    private static void addMetadataFromVisitor(JarVisitor visitor, PersistenceMetadata metadata) throws IOException {
        Set[] entries = visitor.getMatchingEntries();
        JarVisitor.Filter[] filters = visitor.getFilters();
        int size = filters.length;
        List<String> classes = metadata.getClasses();
        List<String> packages = metadata.getPackages();
        List<InputStream> hbmFiles = metadata.getHbmfiles();
        for (int index = 0; index < size; ++index) {
            for (JarVisitor.Entry entry : entries[index]) {
                if (filters[index] instanceof JarVisitor.ClassFilter) {
                    classes.add(entry.getName());
                    continue;
                }
                if (filters[index] instanceof JarVisitor.PackageFilter) {
                    packages.add(entry.getName());
                    continue;
                }
                if (!(filters[index] instanceof JarVisitor.FileFilter)) continue;
                hbmFiles.add(entry.getInputStream());
                metadata.getMappingFiles().remove(entry.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map integration) {
        EntityManagerFactory entityManagerFactory;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing " + LogHelper.logPersistenceUnitInfo(info)));
        } else {
            log.info((Object)("Processing PersistenceUnitInfo [\n\tname: " + info.getPersistenceUnitName() + "\n\t...]"));
        }
        integration = integration != null ? Collections.unmodifiableMap(integration) : CollectionHelper.EMPTY_MAP;
        String provider = (String)integration.get("javax.persistence.provider");
        if (provider == null) {
            provider = info.getPersistenceProviderClassName();
        }
        if (provider != null && !provider.trim().startsWith(IMPLEMENTATION_NAME)) {
            log.info((Object)("Required a different provider: " + provider));
            return null;
        }
        if (info.getClassLoader() == null) {
            throw new IllegalStateException("[PersistenceUnit: " + info.getPersistenceUnitName() == null ? "" : info.getPersistenceUnitName() + "] " + "PersistenceUnitInfo.getClassLoader() id null");
        }
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        if (!info.getClassLoader().equals(contextClassLoader)) {
            thread.setContextClassLoader(info.getClassLoader());
        }
        try {
            PersistenceUnitTransactionType transactionType;
            HashMap<String, Object> workingVars = new HashMap<String, Object>();
            workingVars.put("hibernate.ejb.persistenceUnitName", info.getPersistenceUnitName());
            ArrayList<String> entities = new ArrayList<String>(50);
            if (info.getManagedClassNames() != null) {
                entities.addAll(info.getManagedClassNames());
            }
            ArrayList<InputStream> hbmFiles = new ArrayList<InputStream>();
            ArrayList<String> packages = new ArrayList<String>();
            ArrayList<String> xmlFiles = new ArrayList<String>(50);
            if (info.getMappingFileNames() != null) {
                xmlFiles.addAll(info.getMappingFileNames());
            }
            if (!xmlFiles.contains(META_INF_ORM_XML)) {
                xmlFiles.add(META_INF_ORM_XML);
            }
            transactionType = (transactionType = info.getTransactionType()) != null ? transactionType : PersistenceUnitTransactionType.JTA;
            this.defineTransactionType((Object)transactionType, workingVars);
            boolean[] detectArtifact = this.getDetectedArtifacts(info.getProperties(), null);
            for (URL jar : info.getJarFileUrls()) {
                if (detectArtifact[0]) {
                    this.scanForClasses(jar, packages, entities);
                }
                if (!detectArtifact[1]) continue;
                this.scanForHbmXmlFiles(jar, hbmFiles);
            }
            if (!info.excludeUnlistedClasses()) {
                if (detectArtifact[0]) {
                    this.scanForClasses(info.getPersistenceUnitRootUrl(), packages, entities);
                }
                if (detectArtifact[1]) {
                    this.scanForHbmXmlFiles(info.getPersistenceUnitRootUrl(), hbmFiles);
                }
            }
            Properties properties = info.getProperties() != null ? info.getProperties() : new Properties();
            ConfigurationHelper.overrideProperties(properties, integration);
            this.addXMLEntities(xmlFiles, info, entities);
            if ("true".equalsIgnoreCase(properties.getProperty("hibernate.ejb.use_class_enhancer"))) {
                info.addTransformer(new InterceptFieldClassFileTransformer(entities));
            }
            workingVars.put("hibernate.ejb.classes", entities);
            workingVars.put("hibernate.ejb.packages", packages);
            workingVars.put("hibernate.ejb.xml_files", xmlFiles);
            if (hbmFiles.size() > 0) {
                workingVars.put("hibernate.hbmxml.files", hbmFiles);
            }
            boolean overridenDatasource = false;
            String dataSource = (String)integration.get("javax.persistence.jtaDataSource");
            if (dataSource != null) {
                overridenDatasource = true;
                properties.setProperty("hibernate.connection.datasource", dataSource);
            }
            if ((dataSource = (String)integration.get("javax.persistence.nonJtaDataSource")) != null) {
                overridenDatasource = true;
                properties.setProperty("hibernate.connection.datasource", dataSource);
            }
            if (!(overridenDatasource || info.getJtaDataSource() == null && info.getNonJtaDataSource() == null)) {
                this.setDataSource(info.getJtaDataSource() != null ? info.getJtaDataSource() : info.getNonJtaDataSource());
                this.setProperty("hibernate.connection.provider_class", InjectedDataSourceConnectionProvider.class.getName());
            }
            entityManagerFactory = this.createEntityManagerFactory(properties, workingVars);
        }
        finally {
            if (!info.getClassLoader().equals(contextClassLoader)) {
                thread.setContextClassLoader(contextClassLoader);
            }
        }
        return entityManagerFactory;
    }

    private void addXMLEntities(List<String> xmlFiles, PersistenceUnitInfo info, List<String> entities) {
        ClassLoader newTempClassLoader = info.getNewTempClassLoader();
        if (newTempClassLoader == null) {
            log.warn((Object)"Persistence provider caller does not implements the EJB3 spec correctly. PersistenceUnitInfo.getNewTempClassLoader() is null.");
            return;
        }
        XMLHelper xmlHelper = new XMLHelper();
        ArrayList errors = new ArrayList();
        SAXReader saxReader = xmlHelper.createSAXReader("XML InputStream", errors, this.cfg.getEntityResolver());
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
        for (String xmlFile : xmlFiles) {
            InputStream resourceAsStream = newTempClassLoader.getResourceAsStream(xmlFile);
            if (resourceAsStream == null) continue;
            BufferedInputStream is = new BufferedInputStream(resourceAsStream);
            try {
                errors.clear();
                Document doc = saxReader.read((InputStream)is);
                if (errors.size() != 0) {
                    throw new MappingException("invalid mapping", (Throwable)errors.get(0));
                }
                Element rootElement = doc.getRootElement();
                if (rootElement != null && "entity-mappings".equals(rootElement.getName())) {
                    String classname;
                    Element element = rootElement.element("package");
                    String defaultPackage = element != null ? element.getTextTrim() : null;
                    List elements = rootElement.elements("entity");
                    for (Element subelement : elements) {
                        classname = XMLContext.buildSafeClassName(subelement.attributeValue("class"), defaultPackage);
                        if (entities.contains(classname)) continue;
                        entities.add(classname);
                    }
                    elements = rootElement.elements("mapped-superclass");
                    for (Element subelement : elements) {
                        classname = XMLContext.buildSafeClassName(subelement.attributeValue("class"), defaultPackage);
                        if (entities.contains(classname)) continue;
                        entities.add(classname);
                    }
                    elements = rootElement.elements("embeddable");
                    for (Element subelement : elements) {
                        classname = XMLContext.buildSafeClassName(subelement.attributeValue("class"), defaultPackage);
                        if (entities.contains(classname)) continue;
                        entities.add(classname);
                    }
                    continue;
                }
                if (rootElement == null || !"hibernate-mappings".equals(rootElement.getName())) continue;
            }
            catch (DocumentException e) {
                throw new MappingException("Could not parse mapping document in input stream", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)"Could not close input stream", (Throwable)ioe);
                }
            }
        }
    }

    private void defineTransactionType(Object overridenTxType, Map workingVars) {
        if (overridenTxType != null) {
            if (overridenTxType instanceof String) {
                this.transactionType = PersistenceXmlLoader.getTransactionType((String)overridenTxType);
            } else if (overridenTxType instanceof PersistenceUnitTransactionType) {
                this.transactionType = (PersistenceUnitTransactionType)((Object)overridenTxType);
            } else {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "javax.persistence.transactionType" + " of the wrong class type" + ": " + overridenTxType.getClass());
            }
        }
    }

    public Ejb3Configuration setProperty(String key, String value) {
        this.cfg.setProperty(key, value);
        return this;
    }

    private boolean[] getDetectedArtifacts(Properties properties, Map overridenProperties) {
        boolean[] result = new boolean[]{false, false};
        String detect = overridenProperties != null ? (String)overridenProperties.get("hibernate.archive.autodetection") : null;
        detect = detect == null ? properties.getProperty("hibernate.archive.autodetection", "class,hbm") : detect;
        StringTokenizer st = new StringTokenizer(detect, ",", false);
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            if ("class".equalsIgnoreCase(element)) {
                result[0] = true;
            }
            if (!"hbm".equalsIgnoreCase(element)) continue;
            result[1] = true;
        }
        log.debug((Object)("Detect class: " + result[0] + "; detect hbm: " + result[1]));
        return result;
    }

    private JarVisitor.Filter[] getFilters(Properties properties, Map overridenProperties, final List<String> mappingFiles) {
        boolean[] result = this.getDetectedArtifacts(properties, overridenProperties);
        int size = (result[0] ? 2 : 0) + 1;
        JarVisitor.Filter[] filters = new JarVisitor.Filter[size];
        if (result[0]) {
            filters[0] = new JarVisitor.PackageFilter(false, null){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
            filters[1] = new JarVisitor.ClassFilter(false, new Class[]{Entity.class, MappedSuperclass.class, Embeddable.class}){

                public boolean accept(String javaElementName) {
                    return true;
                }
            };
        }
        filters[size - 1] = result[1] ? new JarVisitor.FileFilter(true){

            public boolean accept(String javaElementName) {
                log.fatal((Object)(javaElementName + "O-:-O" + mappingFiles.contains(javaElementName)));
                return javaElementName.endsWith("hbm.xml") || javaElementName.endsWith(Ejb3Configuration.META_INF_ORM_XML) || mappingFiles.contains(javaElementName);
            }
        } : new JarVisitor.FileFilter(true){

            public boolean accept(String javaElementName) {
                log.fatal((Object)(javaElementName + "O:O" + mappingFiles.contains(javaElementName)));
                return javaElementName.endsWith(Ejb3Configuration.META_INF_ORM_XML) || mappingFiles.contains(javaElementName);
            }
        };
        return filters;
    }

    private void scanForHbmXmlFiles(URL jar, List<InputStream> hbmxmls) {
        Iterator it = ArchiveBrowser.getBrowser((URL)jar, (ArchiveBrowser.Filter)new ArchiveBrowser.Filter(){

            public boolean accept(String filename) {
                return filename.endsWith(".hbm.xml");
            }
        });
        while (it.hasNext()) {
            InputStream stream = (InputStream)it.next();
            hbmxmls.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForClasses(URL jar, List<String> packages, List<String> entities) {
        Iterator it = null;
        try {
            it = ArchiveBrowser.getBrowser((URL)jar, (ArchiveBrowser.Filter)new ArchiveBrowser.Filter(){

                public boolean accept(String filename) {
                    return filename.endsWith(".class");
                }
            });
        }
        catch (RuntimeException e) {
            throw new RuntimeException("error trying to scan <jar-file>: " + jar.toString(), e);
        }
        while (it.hasNext()) {
            boolean isEmbeddableSuperclass;
            boolean isEmbeddable;
            boolean isEntity;
            InputStream stream = (InputStream)it.next();
            DataInputStream dstream = new DataInputStream(stream);
            ClassFile cf = null;
            try {
                try {
                    cf = new ClassFile(dstream);
                }
                finally {
                    dstream.close();
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (cf.getName().endsWith(".package-info")) {
                int idx = cf.getName().indexOf(".package-info");
                String pkgName = cf.getName().substring(0, idx);
                log.info((Object)("found package: " + pkgName));
                packages.add(pkgName);
                continue;
            }
            AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
            if (visible == null) continue;
            boolean bl = isEntity = visible.getAnnotation(Entity.class.getName()) != null;
            if (isEntity) {
                log.info((Object)("found EJB3 Entity bean: " + cf.getName()));
                entities.add(cf.getName());
            }
            boolean bl2 = isEmbeddable = visible.getAnnotation(Embeddable.class.getName()) != null;
            if (isEmbeddable) {
                log.info((Object)("found EJB3 @Embeddable: " + cf.getName()));
                entities.add(cf.getName());
            }
            if (!(isEmbeddableSuperclass = visible.getAnnotation(MappedSuperclass.class.getName()) != null)) continue;
            log.info((Object)("found EJB3 @MappedSuperclass: " + cf.getName()));
            entities.add(cf.getName());
        }
    }

    public EntityManagerFactory createEntityManagerFactory(Map workingVars) {
        Properties props = new Properties();
        if (workingVars != null) {
            props.putAll((Map<?, ?>)workingVars);
            props.remove("hibernate.ejb.classes");
            props.remove("hibernate.ejb.packages");
            props.remove("hibernate.hbmxml.files");
            props.remove("hibernate.ejb.loaded.classes");
        }
        return this.createEntityManagerFactory(props, workingVars);
    }

    public EntityManagerFactory createEntityManagerFactory() {
        return this.createEntityManagerFactory(this.cfg.getProperties(), new HashMap());
    }

    private EntityManagerFactory buildEntityManagerFactory(boolean discardOnClose) {
        return new EntityManagerFactoryImpl(this.cfg.buildSessionFactory(), this.transactionType, discardOnClose);
    }

    private EntityManagerFactory createEntityManagerFactory(Properties properties, Map workingVars) {
        Properties preparedProperties = this.prepareProperties(properties, workingVars);
        if (workingVars == null) {
            workingVars = CollectionHelper.EMPTY_MAP;
        }
        if (preparedProperties.containsKey("hibernate.ejb.cfgfile")) {
            String cfgFileName = preparedProperties.getProperty("hibernate.ejb.cfgfile");
            this.cfg.configure(cfgFileName);
        }
        this.cfg.addProperties(preparedProperties);
        this.addClassesToSessionFactory(workingVars);
        ArrayList<String> jaccKeys = new ArrayList<String>();
        AnnotationConfiguration defaultConf = new AnnotationConfiguration();
        Interceptor defaultInterceptor = defaultConf.getInterceptor();
        NamingStrategy defaultNamingStrategy = defaultConf.getNamingStrategy();
        for (Object uncastObject : preparedProperties.keySet()) {
            if (uncastObject == null || !(uncastObject instanceof String)) continue;
            String propertyKey = (String)uncastObject;
            if (propertyKey.startsWith("hibernate.ejb.classcache")) {
                this.setCacheStrategy(propertyKey, preparedProperties, true, workingVars);
                continue;
            }
            if (propertyKey.startsWith("hibernate.ejb.collectioncache")) {
                this.setCacheStrategy(propertyKey, preparedProperties, false, workingVars);
                continue;
            }
            if (!propertyKey.startsWith("hibernate.jacc") || propertyKey.equals("hibernate.jacc.ctx.id") || propertyKey.equals("hibernate.jacc.enabled")) continue;
            jaccKeys.add(propertyKey);
        }
        if (preparedProperties.containsKey("hibernate.ejb.interceptor") && (this.cfg.getInterceptor() == null || this.cfg.getInterceptor().equals(defaultInterceptor))) {
            String interceptorName = preparedProperties.getProperty("hibernate.ejb.interceptor");
            try {
                Class interceptor = this.classForName(interceptorName);
                this.cfg.setInterceptor((Interceptor)interceptor.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to find interceptor class: " + interceptorName, e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to access interceptor class: " + interceptorName, e);
            }
            catch (InstantiationException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to instanciate interceptor class: " + interceptorName, e);
            }
            catch (ClassCastException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Interceptor class does not implement Interceptor interface: " + interceptorName, e);
            }
        }
        if (preparedProperties.containsKey("hibernate.ejb.naming_strategy") && (this.cfg.getNamingStrategy() == null || this.cfg.getNamingStrategy().equals(defaultNamingStrategy))) {
            String namingStrategyName = preparedProperties.getProperty("hibernate.ejb.naming_strategy");
            try {
                Class namingStragegy = this.classForName(namingStrategyName);
                this.cfg.setNamingStrategy((NamingStrategy)namingStragegy.newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to find naming strategy class: " + namingStrategyName, e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to access naming strategy class: " + namingStrategyName, e);
            }
            catch (InstantiationException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to instanciate naming strategy class: " + namingStrategyName, e);
            }
            catch (ClassCastException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Naming strategyy class does not implement NmaingStrategy interface: " + namingStrategyName, e);
            }
        }
        if (jaccKeys.size() > 0) {
            this.addSecurity(jaccKeys, preparedProperties, workingVars);
        }
        this.listenerConfigurator.setProperties(preparedProperties);
        this.listenerConfigurator.configure();
        if (!"true".equalsIgnoreCase(this.cfg.getProperty("hibernate.connection.autocommit"))) {
            log.warn((Object)"hibernate.connection.autocommit = false break the EJB3 specification");
        }
        boolean discardOnClose = preparedProperties.getProperty("hibernate.ejb.discard_pc_on_close").equals("true");
        return this.buildEntityManagerFactory(discardOnClose);
    }

    private void addClassesToSessionFactory(Map workingVars) {
        if (workingVars.containsKey("hibernate.ejb.classes")) {
            Collection classNames = (Collection)workingVars.get("hibernate.ejb.classes");
            this.addNamedAnnotatedClasses(this, classNames, workingVars);
        }
        if (workingVars.containsKey("hibernate.ejb.loaded.classes")) {
            Collection classes = (Collection)workingVars.get("hibernate.ejb.loaded.classes");
            for (Class clazz : classes) {
                this.cfg.addAnnotatedClass(clazz);
            }
        }
        if (workingVars.containsKey("hibernate.ejb.packages")) {
            Collection packages = (Collection)workingVars.get("hibernate.ejb.packages");
            for (String pkg : packages) {
                this.cfg.addPackage(pkg);
            }
        }
        if (workingVars.containsKey("hibernate.ejb.xml_files")) {
            Collection xmlFiles = (Collection)workingVars.get("hibernate.ejb.xml_files");
            for (String xmlFile : xmlFiles) {
                Boolean useMetaInf = null;
                try {
                    if (xmlFile.endsWith(META_INF_ORM_XML)) {
                        useMetaInf = true;
                    }
                    this.cfg.addResource(xmlFile);
                }
                catch (MappingException me) {
                    if (!xmlFile.endsWith(META_INF_ORM_XML)) {
                        throw new PersistenceException(this.getExceptionHeader(workingVars) + "Unable to find XML mapping file in classpath: " + xmlFile);
                    }
                    useMetaInf = false;
                }
                if (!log.isInfoEnabled()) continue;
                if (Boolean.TRUE.equals(useMetaInf)) {
                    log.info((Object)(this.getExceptionHeader(workingVars) + META_INF_ORM_XML + " found"));
                    continue;
                }
                if (!Boolean.FALSE.equals(useMetaInf)) continue;
                log.info((Object)(this.getExceptionHeader(workingVars) + "no " + META_INF_ORM_XML + " found"));
            }
        }
        if (workingVars.containsKey("hibernate.hbmxml.files")) {
            Collection hbmXmlFiles = (Collection)workingVars.get("hibernate.hbmxml.files");
            for (InputStream is : hbmXmlFiles) {
                this.cfg.addInputStream(is);
            }
        }
    }

    private String getExceptionHeader(Map workingVars) {
        if (workingVars != null) {
            String puName = (String)workingVars.get("hibernate.ejb.persistenceUnitName");
            puName = puName == null ? "" : puName;
            String header = "[PersistenceUnit: " + puName + "] ";
            return header;
        }
        return "";
    }

    private Properties prepareProperties(Properties properties, Map workingVars) {
        Properties preparedProperties = new Properties();
        preparedProperties.setProperty("hibernate.connection.release_mode", "auto");
        preparedProperties.setProperty("hibernate.connection.autocommit", "true");
        preparedProperties.setProperty("hibernate.use_identifier_rollback", "false");
        preparedProperties.setProperty("hibernate.transaction.flush_before_completion", "false");
        preparedProperties.setProperty("hibernate.ejb.discard_pc_on_close", "false");
        if (properties != null) {
            preparedProperties.putAll((Map<?, ?>)properties);
        }
        if (this.transactionType == null) {
            this.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        this.defineTransactionType(preparedProperties.getProperty("javax.persistence.transactionType"), workingVars);
        boolean hasTxStrategy = StringHelper.isNotEmpty(preparedProperties.getProperty("hibernate.transaction.factory_class"));
        if (!hasTxStrategy && this.transactionType == PersistenceUnitTransactionType.JTA) {
            preparedProperties.setProperty("hibernate.transaction.factory_class", JoinableCMTTransactionFactory.class.getName());
        } else if (!hasTxStrategy && this.transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            preparedProperties.setProperty("hibernate.transaction.factory_class", JDBCTransactionFactory.class.getName());
        }
        if (hasTxStrategy) {
            log.warn((Object)"Overriding hibernate.transaction.factory_class is dangerous, this might break the EJB3 specification implementation");
        }
        if (preparedProperties.getProperty("hibernate.transaction.flush_before_completion").equals("true")) {
            preparedProperties.setProperty("hibernate.transaction.flush_before_completion", "false");
            log.warn((Object)"Defining hibernate.transaction.flush_before_completion=true ignored in HEM");
        }
        return preparedProperties;
    }

    private Class classForName(String className) throws ClassNotFoundException {
        return ReflectHelper.classForName(className, this.getClass());
    }

    private void setCacheStrategy(String propertyKey, Map properties, boolean isClass, Map workingVars) {
        String role = propertyKey.substring((isClass ? "hibernate.ejb.classcache".length() : "hibernate.ejb.collectioncache".length()) + 1);
        String value = (String)properties.get(propertyKey);
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            error.append(isClass ? "hibernate.ejb.classcache" : "hibernate.ejb.collectioncache");
            error.append(": ").append(propertyKey).append(" ").append(value);
            throw new PersistenceException(this.getExceptionHeader(workingVars) + error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        if (isClass) {
            boolean lazyProperty = true;
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
            this.cfg.setCacheConcurrencyStrategy(role, usage, region, lazyProperty);
        } else {
            this.cfg.setCollectionCacheConcurrencyStrategy(role, usage, region);
        }
    }

    private void addSecurity(List<String> keys, Map properties, Map workingVars) {
        log.debug((Object)"Adding security");
        if (!properties.containsKey("hibernate.jacc.ctx.id")) {
            throw new PersistenceException(this.getExceptionHeader(workingVars) + "Entities have been configured for JACC, but " + "hibernate.jacc.ctx.id" + " has not been set");
        }
        String contextId = (String)properties.get("hibernate.jacc.ctx.id");
        this.setProperty("hibernate.jacc_context_id", contextId);
        int roleStart = "hibernate.jacc".length() + 1;
        for (String key : keys) {
            JACCConfiguration jaccCfg = new JACCConfiguration(contextId);
            try {
                String role = key.substring(roleStart, key.indexOf(46, roleStart));
                int classStart = roleStart + role.length() + 1;
                String clazz = key.substring(classStart, key.length());
                String actions = (String)properties.get(key);
                jaccCfg.addPermission(role, clazz, actions);
            }
            catch (IndexOutOfBoundsException e) {
                throw new PersistenceException(this.getExceptionHeader(workingVars) + "Illegal usage of " + "hibernate.jacc" + ": " + key);
            }
        }
    }

    private void addNamedAnnotatedClasses(Ejb3Configuration cfg, Collection<String> classNames, Map workingVars) {
        for (String name : classNames) {
            try {
                Class clazz = this.classForName(name);
                cfg.addAnnotatedClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                Package pkg;
                try {
                    pkg = this.classForName(name + ".package-info").getPackage();
                }
                catch (ClassNotFoundException e) {
                    pkg = null;
                }
                if (pkg == null) {
                    throw new PersistenceException(this.getExceptionHeader(workingVars) + "class or package not found", cnfe);
                }
                cfg.addPackage(name);
            }
        }
    }

    public Settings buildSettings() throws HibernateException {
        return this.settingsFactory.buildSettings(this.cfg.getProperties());
    }

    public Ejb3Configuration addProperties(Properties props) {
        this.cfg.addProperties(props);
        return this;
    }

    public Ejb3Configuration addAnnotatedClass(Class persistentClass) throws MappingException {
        this.cfg.addAnnotatedClass(persistentClass);
        return this;
    }

    public Ejb3Configuration configure(String resource) throws HibernateException {
        this.cfg.configure(resource);
        return this;
    }

    public Ejb3Configuration addPackage(String packageName) throws MappingException {
        this.cfg.addPackage(packageName);
        return this;
    }

    public Ejb3Configuration addFile(String xmlFile) throws MappingException {
        this.cfg.addFile(xmlFile);
        return this;
    }

    public Ejb3Configuration addClass(Class persistentClass) throws MappingException {
        this.cfg.addClass(persistentClass);
        return this;
    }

    public Ejb3Configuration addFile(File xmlFile) throws MappingException {
        this.cfg.addFile(xmlFile);
        return this;
    }

    public void buildMappings() {
        this.cfg.buildMappings();
    }

    public Iterator getClassMappings() {
        return this.cfg.getClassMappings();
    }

    public EventListeners getEventListeners() {
        return this.cfg.getEventListeners();
    }

    SessionFactory buildSessionFactory() throws HibernateException {
        return this.cfg.buildSessionFactory();
    }

    public Iterator getTableMappings() {
        return this.cfg.getTableMappings();
    }

    public PersistentClass getClassMapping(String persistentClass) {
        return this.cfg.getClassMapping(persistentClass);
    }

    public org.hibernate.mapping.Collection getCollectionMapping(String role) {
        return this.cfg.getCollectionMapping(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.cfg.setEntityResolver(entityResolver);
    }

    public Map getNamedQueries() {
        return this.cfg.getNamedQueries();
    }

    public Interceptor getInterceptor() {
        return this.cfg.getInterceptor();
    }

    public Properties getProperties() {
        return this.cfg.getProperties();
    }

    public Ejb3Configuration setInterceptor(Interceptor interceptor) {
        this.cfg.setInterceptor(interceptor);
        return this;
    }

    public Ejb3Configuration setProperties(Properties properties) {
        this.cfg.setProperties(properties);
        return this;
    }

    public Map getFilterDefinitions() {
        return this.cfg.getFilterDefinitions();
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.cfg.addFilterDefinition(definition);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        this.cfg.addAuxiliaryDatabaseObject(object);
    }

    public NamingStrategy getNamingStrategy() {
        return this.cfg.getNamingStrategy();
    }

    public Ejb3Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.cfg.setNamingStrategy(namingStrategy);
        return this;
    }

    public void setListeners(String type, String[] listenerClasses) {
        this.cfg.setListeners(type, listenerClasses);
    }

    public void setListeners(String type, Object[] listeners) {
        this.cfg.setListeners(type, listeners);
    }

    public AnnotationConfiguration getHibernateConfiguration() {
        return this.cfg;
    }

    public Ejb3Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        this.cfg.addInputStream(xmlInputStream);
        return this;
    }

    public Ejb3Configuration addResource(String path) throws MappingException {
        this.cfg.addResource(path);
        return this;
    }

    public Ejb3Configuration addResource(String path, ClassLoader classLoader) throws MappingException {
        this.cfg.addResource(path, classLoader);
        return this;
    }

    static {
        Version.touch();
    }
}

