/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode;

import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.bytecode.ClassTransformer;

public abstract class AbstractClassTransformerImpl
implements ClassTransformer {
    private final Set entities;
    private final String[] packages;

    public AbstractClassTransformerImpl(String[] packages, String[] classes) {
        this.packages = packages;
        if (classes == null) {
            this.entities = null;
        } else {
            this.entities = new HashSet();
            for (int i = 0; i < classes.length; ++i) {
                this.entities.add(classes[i]);
            }
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        boolean enhance = false;
        String safeClassName = className.replace('/', '.');
        if (this.entities == null && this.packages == null) {
            enhance = true;
        }
        if (!enhance && this.entities != null && this.entities.contains(safeClassName)) {
            enhance = true;
        }
        if (!enhance && this.packages != null) {
            for (int i = 0; i < this.packages.length; ++i) {
                if (!safeClassName.startsWith(this.packages[i])) continue;
                enhance = true;
                break;
            }
        }
        if (!enhance) {
            return classfileBuffer;
        }
        return this.doTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    protected abstract byte[] doTransform(ClassLoader var1, String var2, Class var3, ProtectionDomain var4, byte[] var5);
}

