/*
	* Copyright (C) 2017-2024 Sebastiano Vigna
	*
	* Licensed under the Apache License, Version 2.0 (the "License");
	* you may not use this file except in compliance with the License.
	* You may obtain a copy of the License at
	*
	*     http://www.apache.org/licenses/LICENSE-2.0
	*
	* Unless required by applicable law or agreed to in writing, software
	* distributed under the License is distributed on an "AS IS" BASIS,
	* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	* See the License for the specific language governing permissions and
	* limitations under the License.
	*/
package it.unimi.dsi.fastutil.doubles;

import java.util.function.BiConsumer;

/**
 * A type-specific {@link BiConsumer}.
 *
 * @see BiConsumer
 * @since 8.5.18
 */
@FunctionalInterface
public interface DoubleFloatBiConsumer extends BiConsumer<Double, Float> {
	/**
	 * Performs this operation on the given entry.
	 *
	 * @param k the key.
	 * @param v the value.
	 */
	void accept(double k, float v);

	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	default void accept(Double key, Float value) {
		this.accept(key.doubleValue(), value.floatValue());
	}

	default DoubleFloatBiConsumer andThen(final DoubleFloatBiConsumer after) {
		java.util.Objects.requireNonNull(after);
		return (k, v) -> {
			accept(k, v);
			after.accept(k, v);
		};
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated Please use the corresponding type-specific method instead.
	 */
	@Deprecated
	@Override
	default BiConsumer<Double, Float> andThen(final BiConsumer<? super Double, ? super Float> after) {
		return BiConsumer.super.andThen(after);
	}
}
