/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.web;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class TracingClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    static final Propagation.Setter<HttpHeaders, String> SETTER = new Propagation.Setter<HttpHeaders, String>(){

        public void put(HttpHeaders carrier, String key, String value) {
            carrier.set(key, value);
        }

        public String toString() {
            return "HttpHeaders::set";
        }
    };
    final Tracer tracer;
    final HttpClientHandler<HttpRequest, ClientHttpResponse> handler;
    final TraceContext.Injector<HttpHeaders> injector;

    public static ClientHttpRequestInterceptor create(Tracing tracing) {
        return TracingClientHttpRequestInterceptor.create(HttpTracing.create((Tracing)tracing));
    }

    public static ClientHttpRequestInterceptor create(HttpTracing httpTracing) {
        return new TracingClientHttpRequestInterceptor(httpTracing);
    }

    @Autowired
    TracingClientHttpRequestInterceptor(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
    }

    /*
     * Loose catch block
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse clientHttpResponse;
        Tracer.SpanInScope ws;
        Throwable error;
        ClientHttpResponse response;
        Span span;
        block10: {
            span = this.handler.handleSend(this.injector, (Object)request.getHeaders(), (Object)request);
            response = null;
            error = null;
            ws = this.tracer.withSpanInScope(span);
            clientHttpResponse = response = execution.execute(request, body);
            if (ws == null) break block10;
            ws.close();
        }
        this.handler.handleReceive((Object)response, error, span);
        return clientHttpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | Error | RuntimeException e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    this.handler.handleReceive(response, error, span);
                    throw throwable3;
                }
            }
        }
    }

    static final class HttpAdapter
    extends HttpClientAdapter<HttpRequest, ClientHttpResponse> {
        HttpAdapter() {
        }

        public String method(HttpRequest request) {
            return request.getMethod().name();
        }

        public String url(HttpRequest request) {
            return request.getURI().toString();
        }

        public String requestHeader(HttpRequest request, String name) {
            String result = request.getHeaders().getFirst(name);
            return result != null ? result.toString() : "";
        }

        public Integer statusCode(ClientHttpResponse response) {
            try {
                return response.getRawStatusCode();
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

