/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.responses;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class APIResponsesIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<APIResponses, V, A, O, AB, OB> {
    public APIResponsesIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.API_RESPONSES, Names.create(APIResponses.class));
    }

    @Override
    public APIResponses read(AnnotationTarget target) {
        Map<String, APIResponse> responseMap = this.apiResponseIO().readMap(target);
        Map extensions = Optional.ofNullable(this.getAnnotation(target)).map(this.extensionIO()::readExtensible).orElse(null);
        if (!responseMap.isEmpty() || extensions != null) {
            APIResponses responses = OASFactory.createAPIResponses();
            responseMap.forEach((arg_0, arg_1) -> ((APIResponses)responses).addAPIResponse(arg_0, arg_1));
            responses.setExtensions(extensions);
            return responses;
        }
        return null;
    }

    @Override
    public APIResponses read(AnnotationInstance annotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public APIResponses read(AnnotationValue annotation) {
        return Optional.ofNullable(annotation).map(AnnotationValue::asNestedArray).map(this::read).orElse(null);
    }

    public Optional<Map<String, APIResponse>> readResponseSchema(AnnotationTarget target) {
        return Optional.ofNullable(this.scannerContext().annotations().getAnnotation(target, Names.API_RESPONSE_SCHEMA)).map(this.apiResponseIO()::readResponseSchema);
    }

    public APIResponses read(AnnotationInstance[] annotations) {
        IoLogging.logger.annotationsListInto("@APIResponse", "APIResponses model");
        APIResponses responses = OASFactory.createAPIResponses();
        for (AnnotationInstance nested : annotations) {
            this.apiResponseIO().responseCode(nested).ifPresent(responseCode -> responses.addAPIResponse(responseCode, this.apiResponseIO().read(nested)));
        }
        return responses;
    }
}

